/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter;

import java.util.Set;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConverterUtil {
    public static void copyAllAttributes(Element source, Element dest, Set ignore) {
        NamedNodeMap attrs = source.getAttributes();
        int i = 0;
        int size = attrs.getLength();
        while (i < size) {
            Attr attr = (Attr)attrs.item(i);
            if (ignore == null || !ignore.contains(attr.getName())) {
                dest.setAttribute(attr.getName(), attr.getValue());
            }
            ++i;
        }
    }

    public static void copyAttribute(Element source, String srcattr, Element dest, String destattr) {
        Attr attr = source.getAttributeNode(srcattr);
        if (attr != null) {
            dest.setAttribute(destattr, attr.getValue());
        }
    }

    public static boolean isEmptyContainer(Element hostElement) {
        NodeList nl = hostElement.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return true;
        }
        int i = 0;
        int n = nl.getLength();
        while (i < n) {
            Node node = nl.item(i);
            if (!(node instanceof IDOMText)) {
                return false;
            }
            if (!((IDOMText)node).isElementContentWhitespace()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Element createDescriptionElement(IDOMDocument document, String text) {
        if (document == null) {
            return null;
        }
        Element span = document.createElement("span");
        span.setAttribute("style", "color:gray;font-style:italic;font-size:normal;");
        if (text == null) {
            span.appendChild(document.createTextNode(PDPlugin.getResourceString("ConverterUtil.Description")));
        } else {
            span.appendChild(document.createTextNode(text));
        }
        return span;
    }
}

