/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class UnwrappingSelectionProvider
implements ISelectionProvider {
    protected ISelection selection;
    protected List<ISelectionChangedListener> listeners = new UniqueEList.FastCompare();
    protected ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            UnwrappingSelectionProvider.this.setSelection(event.getSelection());
        }
    };

    public UnwrappingSelectionProvider(ISelectionProvider selectionProvider) {
        selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
        this.setSelection(selectionProvider.getSelection());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] objects = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < objects.length) {
                objects[i] = this.unwrap(objects[i]);
                ++i;
            }
            this.selection = new StructuredSelection(objects);
        } else {
            this.selection = selection;
        }
        this.fireSelectionChanged();
    }

    protected Object unwrap(Object object) {
        return AdapterFactoryEditingDomain.unwrap((Object)object);
    }

    protected void fireSelectionChanged() {
        for (ISelectionChangedListener selectionChangedListener : this.listeners) {
            selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.selection));
        }
    }
}

