/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Arrays;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EntityNameCombo
extends BaseJpaController {
    private IEntity entity;
    private Adapter entityListener;
    private CCombo combo;

    public EntityNameCombo(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, commandStack, widgetFactory);
        this.buildEntityListener();
    }

    private void buildEntityListener() {
        this.entityListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                EntityNameCombo.this.entityChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        this.combo = this.widgetFactory.createCCombo(parent, 0x800000);
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntityNameCombo.this.comboModified(e);
            }
        });
    }

    private void comboModified(ModifyEvent e) {
        if (this.isPopulating()) {
            return;
        }
        String text = ((CCombo)e.getSource()).getText();
        if (text.equals(this.combo.getItem(0))) {
            text = null;
        }
        this.entity.setSpecifiedName(text);
    }

    private void entityChanged(Notification notification) {
        switch (notification.getFeatureID(IEntity.class)) {
            case 2: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        EntityNameCombo.this.populate();
                    }
                });
                break;
            }
            case 3: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        EntityNameCombo.this.populate();
                    }
                });
            }
        }
    }

    protected void engageListeners() {
        if (this.entity != null) {
            this.entity.eAdapters().add((Object)this.entityListener);
        }
    }

    protected void disengageListeners() {
        if (this.entity != null) {
            this.entity.eAdapters().remove((Object)this.entityListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.entity = (IEntity)obj;
        this.populateCombo();
    }

    protected void doPopulate() {
        this.populateCombo();
    }

    private void populateCombo() {
        if (this.entity == null) {
            this.combo.clearSelection();
            this.combo.setItems(new String[0]);
            return;
        }
        String defaultItem = NLS.bind((String)JptUiMappingsMessages.EntityGeneralSection_nameDefaultWithOneParam, (Object)this.entity.getDefaultName());
        String specifiedName = this.entity.getSpecifiedName();
        if (specifiedName == null) {
            this.setComboData(defaultItem, new String[]{defaultItem});
        } else {
            this.setComboData(specifiedName, new String[]{defaultItem});
        }
    }

    private void setComboData(String text, String[] items) {
        if (!Arrays.equals(items, this.combo.getItems())) {
            this.combo.setItems(items);
        }
        if (!text.equals(this.combo.getText())) {
            this.combo.setText(text);
        }
    }

    public CCombo getCombo() {
        return this.combo;
    }

    public Control getControl() {
        return this.getCombo();
    }
}

