/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jpt.core.internal.IJpaContentNode;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.ui.internal.IJpaPlatformUi;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.PlatformRegistry;
import org.eclipse.jpt.ui.internal.jface.NullLabelProvider;
import org.eclipse.jpt.ui.internal.jface.NullTreeContentProvider;
import org.eclipse.jpt.ui.internal.selection.Selection;
import org.eclipse.jpt.ui.internal.structure.IJpaStructureProvider;
import org.eclipse.jpt.ui.internal.views.AbstractJpaView;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class JpaStructureView
extends AbstractJpaView {
    private StructureComposite structureComposite;

    public JpaStructureView() {
        super(JptUiMessages.JpaStructureView_viewNotAvailable);
    }

    public void subcreatePartControl(Composite parent) {
        this.structureComposite = new StructureComposite((Composite)this.pageBook, 0);
    }

    public Selection getSelection() {
        if (this.structureComposite.isVisible()) {
            return this.structureComposite.getSelection();
        }
        return Selection.NULL_SELECTION;
    }

    public void select(Selection newSelection) {
        Selection currentSelection = this.getSelection();
        if (newSelection.equals(currentSelection)) {
            return;
        }
        if (newSelection == Selection.NULL_SELECTION) {
            this.showDefaultPage();
        } else {
            this.pageBook.showPage((Control)this.structureComposite);
        }
        this.structureComposite.select(newSelection);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.structureComposite.viewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.structureComposite.viewer.removeSelectionChangedListener(listener);
    }

    private class StructureComposite
    extends Composite {
        private Map structureProviders;
        private TreeViewer viewer;

        private StructureComposite(Composite parent, int style) {
            super(parent, style);
            this.structureProviders = new HashMap();
            this.setLayout((Layout)new FillLayout());
            this.viewer = new TreeViewer((Composite)this, 770);
            this.viewer.setAutoExpandLevel(2);
            this.initContextMenu();
        }

        protected void initContextMenu() {
            MenuManager mgr = new MenuManager();
            mgr.setRemoveAllWhenShown(true);
            mgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager mgr) {
                    StructureComposite.this.fillContextMenu(mgr);
                }
            });
            Menu menu = mgr.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
            JpaStructureView.this.getSite().registerContextMenu(mgr, (ISelectionProvider)this.viewer);
        }

        protected void fillContextMenu(IMenuManager manager) {
            manager.add((IContributionItem)new Separator("additions"));
        }

        private Selection getSelection() {
            ITreeSelection viewerSelection = (ITreeSelection)this.viewer.getSelection();
            if (viewerSelection.isEmpty() || viewerSelection.size() > 1) {
                if (this.viewer.getInput() == null) {
                    return Selection.NULL_SELECTION;
                }
                return new Selection((IJpaContentNode)this.viewer.getInput());
            }
            return new Selection((IJpaContentNode)viewerSelection.getFirstElement());
        }

        private void select(Selection selection) {
            IJpaFile currentFile;
            if (selection.equals(Selection.NULL_SELECTION)) {
                this.clearViewer();
                return;
            }
            Selection currentSelection = this.getSelection();
            IJpaContentNode newNode = selection.getSelectedNode();
            IJpaFile newFile = newNode.getJpaFile();
            IJpaContentNode currentNode = currentSelection == Selection.NULL_SELECTION ? null : this.getSelection().getSelectedNode();
            IJpaFile iJpaFile = currentFile = currentNode == null ? null : currentNode.getJpaFile();
            if (newFile.equals(currentFile)) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)newNode), true);
            } else if (currentFile != null && newFile.getContentId().equals(currentFile.getContentId())) {
                this.viewer.setInput((Object)newFile.getContent());
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)newNode), true);
            } else {
                IJpaStructureProvider provider = this.getStructureProvider(newNode);
                if (provider == null) {
                    this.clearViewer();
                } else {
                    this.viewer.setContentProvider((IContentProvider)provider.buildContentProvider());
                    this.viewer.setLabelProvider((IBaseLabelProvider)provider.buildLabelProvider());
                    this.viewer.setInput((Object)newFile.getContent());
                }
            }
        }

        private void clearViewer() {
            this.viewer.setContentProvider((IContentProvider)NullTreeContentProvider.INSTANCE);
            this.viewer.setLabelProvider((IBaseLabelProvider)NullLabelProvider.INSTANCE);
            this.viewer.setInput(null);
        }

        private IJpaStructureProvider getStructureProvider(IJpaContentNode contentNode) {
            String contentId = contentNode.getJpaFile().getContentId();
            IJpaStructureProvider provider = (IJpaStructureProvider)this.structureProviders.get(contentId);
            if (provider == null) {
                String vendorId = contentNode.getJpaProject().getPlatform().getId();
                IJpaPlatformUi jpaPlatformUI = PlatformRegistry.INSTANCE.getJpaPlatform(vendorId);
                for (IJpaStructureProvider p : jpaPlatformUI.structureProviders()) {
                    if (!p.fileContentType().equals(contentId)) continue;
                    provider = p;
                    break;
                }
                if (provider != null) {
                    this.structureProviders.put(contentId, provider);
                }
            }
            return provider;
        }
    }
}

