/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.xml.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.mappings.DefaultFalseBoolean;
import org.eclipse.jpt.ui.internal.details.BaseJpaController;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.widgets.CComboViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class MetaDataCompleteComboViewer
extends BaseJpaController {
    private XmlTypeMapping mapping;
    private Adapter typeMappingListener;
    private CComboViewer comboViewer;

    public MetaDataCompleteComboViewer(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, theCommandStack, widgetFactory);
        this.buildTypeMappingListener();
    }

    private void buildTypeMappingListener() {
        this.typeMappingListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                MetaDataCompleteComboViewer.this.typeMappingChanged(notification);
            }
        };
    }

    protected void buildWidget(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent);
        this.comboViewer = new CComboViewer(combo);
        this.comboViewer.setLabelProvider(this.buildLabelProvider());
        this.comboViewer.add(DefaultFalseBoolean.VALUES.toArray());
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MetaDataCompleteComboViewer.this.metadataCompleteSelectionChanged(event.getSelection());
            }
        });
    }

    private IBaseLabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element == DefaultFalseBoolean.DEFAULT) {
                    return NLS.bind((String)JptUiMappingsMessages.MetaDataCompleteCombo_Default, (Object)"False");
                }
                return super.getText(element);
            }
        };
    }

    void metadataCompleteSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            DefaultFalseBoolean metadataComplete = (DefaultFalseBoolean)((IStructuredSelection)selection).getFirstElement();
            if (!this.mapping.getMetadataComplete().equals((Object)metadataComplete)) {
                this.mapping.setMetadataComplete(metadataComplete);
            }
        }
    }

    private void typeMappingChanged(Notification notification) {
        if (notification.getFeatureID(XmlTypeMapping.class) == 5) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MetaDataCompleteComboViewer.this.populate();
                }
            });
        }
    }

    protected void engageListeners() {
        if (this.mapping != null) {
            this.mapping.eAdapters().add((Object)this.typeMappingListener);
        }
    }

    protected void disengageListeners() {
        if (this.mapping != null) {
            this.mapping.eAdapters().remove((Object)this.typeMappingListener);
        }
    }

    public void doPopulate(EObject obj) {
        this.mapping = (XmlTypeMapping)obj;
        this.populateCombo();
    }

    protected void doPopulate() {
        this.populateCombo();
    }

    private void populateCombo() {
        if (this.mapping == null) {
            return;
        }
        DefaultFalseBoolean metadataComplete = this.mapping.getMetadataComplete();
        if (((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement() != metadataComplete) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)metadataComplete));
        }
    }

    public Control getControl() {
        return this.comboViewer.getCombo();
    }
}

