/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.internet.cache.internal.Cache;
import org.eclipse.wst.internet.cache.internal.CacheMessages;

public class CacheJob
extends Job {
    private static final long SCHEDULE_TIME = 3600000L;
    private static CacheJob job = null;

    public CacheJob() {
        super(CacheMessages._UI_CACHE_MONITOR_NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        boolean allSuccessful = true;
        Cache cache = Cache.getInstance();
        String[] uncachedURIs = cache.getUncachedURIs();
        int numUncachedURIs = uncachedURIs.length;
        cache.clearUncachedURIs();
        monitor.beginTask(CacheMessages._UI_CACHE_MONITOR_NAME, numUncachedURIs);
        try {
            int i = 0;
            while (true) {
                if (i >= numUncachedURIs) {
                    monitor.done();
                    iStatus = Status.OK_STATUS;
                    break;
                }
                if (monitor.isCanceled()) {
                    int j = i;
                    while (true) {
                        if (j >= numUncachedURIs) break;
                        cache.addUncachedURI(uncachedURIs[j]);
                        ++j;
                    }
                    IStatus iStatus2 = Status.CANCEL_STATUS;
                    Object var9_12 = null;
                    if (allSuccessful) return iStatus2;
                    CacheJob.startJob(3600000L);
                    return iStatus2;
                }
                String uri = uncachedURIs[i];
                monitor.setTaskName(MessageFormat.format(CacheMessages._UI_CACHE_MONITOR_CACHING, uri));
                String cachedURI = cache.getResource(uri);
                if (cachedURI == null) {
                    allSuccessful = false;
                }
                monitor.worked(1);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (allSuccessful) throw throwable;
            CacheJob.startJob(3600000L);
            throw throwable;
        }
        Object var9_13 = null;
        if (allSuccessful) return iStatus;
        CacheJob.startJob(3600000L);
        return iStatus;
    }

    protected static void startJob() {
        if (job == null) {
            CacheJob.startJob(0L);
        }
    }

    private static void startJob(long delay) {
        job = new CacheJob();
        job.setPriority(50);
        job.schedule(delay);
    }

    protected static void stopJob() {
        if (job != null) {
            job.cancel();
        }
        job = null;
    }
}

