/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.model.commands;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.shapes.model.Shape;
import org.eclipse.gef.examples.shapes.model.ShapesDiagram;

public class ShapeCreateCommand
extends Command {
    private Shape newShape;
    private final ShapesDiagram parent;
    private Rectangle bounds;

    public ShapeCreateCommand(Shape newShape, ShapesDiagram parent, Rectangle bounds) {
        this.newShape = newShape;
        this.parent = parent;
        this.bounds = bounds;
        this.setLabel("shape creation");
    }

    public boolean canExecute() {
        return this.newShape != null && this.parent != null && this.bounds != null;
    }

    public void execute() {
        this.newShape.setLocation(this.bounds.getLocation());
        Dimension size = this.bounds.getSize();
        if (size.width > 0 && size.height > 0) {
            this.newShape.setSize(size);
        }
        this.redo();
    }

    public void redo() {
        this.parent.addChild(this.newShape);
    }

    public void undo() {
        this.parent.removeChild(this.newShape);
    }
}

