/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuntime
implements IRuntime {
    private static final String PROP_LOCALIZED_NAME = "localized-name";
    private String name;

    AbstractRuntime() {
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getLocalizedName() {
        String localizedName = this.getProperty(PROP_LOCALIZED_NAME);
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    final void setName(String name) {
        this.name = name;
    }

    @Override
    public final String getProperty(String key) {
        return this.getProperties().get(key);
    }

    public final Object getAdapter(Class adapter) {
        String t = adapter.getName();
        Object res = Platform.getAdapterManager().loadAdapter((Object)this, t);
        if (res == null) {
            for (IRuntimeComponent rc : this.getRuntimeComponents()) {
                res = rc.getAdapter(adapter);
                if (res == null) continue;
                return res;
            }
        }
        return res;
    }

    @Override
    public boolean supports(IProjectFacet f) {
        for (IProjectFacetVersion fv : f.getVersions()) {
            if (!this.supports(fv)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IProjectFacetVersion> getDefaultFacets(Set<IProjectFacet> fixed) throws CoreException {
        HashMap<IProjectFacet, IProjectFacetVersion> facets = new HashMap<IProjectFacet, IProjectFacetVersion>();
        for (IRuntimeComponent rc : this.getRuntimeComponents()) {
            Iterator rcv = rc.getRuntimeComponentVersion();
            for (IProjectFacetVersion fv : RuntimeManagerImpl.getDefaultFacets((IRuntimeComponentVersion)((Object)rcv))) {
                if (facets.containsKey(fv.getProjectFacet())) continue;
                facets.put(fv.getProjectFacet(), fv);
            }
        }
        HashSet<IProjectFacet> toRemove = new HashSet<IProjectFacet>();
        for (IProjectFacetVersion fv : facets.values()) {
            if (fv.isValidFor(fixed)) continue;
            toRemove.add(fv.getProjectFacet());
        }
        for (IProjectFacet f : toRemove) {
            facets.remove(f);
        }
        HashMap<IProjectFacet, IProjectFacetVersion> toadd = null;
        for (IProjectFacet f : fixed) {
            if (facets.containsKey(f)) continue;
            if (toadd == null) {
                toadd = new HashMap<IProjectFacet, IProjectFacetVersion>();
            }
            toadd.put(f, f.getLatestSupportedVersion(this));
        }
        if (toadd != null) {
            facets.putAll(toadd);
        }
        return new HashSet<IProjectFacetVersion>(facets.values());
    }

    public final boolean equals(Object obj) {
        if (obj instanceof IRuntime) {
            IRuntime r = (IRuntime)obj;
            return this.getName().equals(r.getName()) && this.getRuntimeComponents().equals(r.getRuntimeComponents()) && this.getProperties().equals(r.getProperties());
        }
        return false;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

