/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.content.java.mappings.AbstractJavaTable;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaJoinColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaUniqueConstraint;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.IJoinTable;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaJoinTable
extends AbstractJavaTable
implements IJoinTable {
    protected EList<IJoinColumn> specifiedJoinColumns;
    protected EList<IJoinColumn> defaultJoinColumns;
    protected EList<IJoinColumn> specifiedInverseJoinColumns;
    protected EList<IJoinColumn> defaultInverseJoinColumns;
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinTable");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "name");
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "schema");
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "catalog");

    protected JavaJoinTable() {
        throw new UnsupportedOperationException("Use JavaJoinTable(Owner, Member) instead");
    }

    protected JavaJoinTable(ITable.Owner owner, Member member) {
        super(owner, member, DECLARATION_ANNOTATION_ADAPTER);
        this.getDefaultJoinColumns().add((Object)this.createJoinColumn(new IJoinTable.JoinColumnOwner(this), member));
        this.getDefaultInverseJoinColumns().add((Object)this.createJoinColumn(new IJoinTable.InverseJoinColumnOwner(this), member));
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> nameAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return NAME_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> schemaAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return SCHEMA_ADAPTER;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> catalogAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return CATALOG_ADAPTER;
    }

    private IJoinColumn createJoinColumn(IJoinColumn.Owner joinColumnOwner, Member joinColumnMember) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaJoinColumn(joinColumnOwner, joinColumnMember);
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IJoinTable.class)) {
            case 11: {
                this.specifiedJoinColumnsChanged(notification);
                break;
            }
            case 14: {
                this.specifiedInverseJoinColumnsChanged(notification);
                break;
            }
        }
    }

    void specifiedJoinColumnsChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.specifiedJoinColumnAdded(notification.getPosition(), (IJoinColumn)notification.getNewValue());
                break;
            }
            case 5: {
                this.specifiedJoinColumnsAdded(notification.getPosition(), (List)notification.getNewValue());
                break;
            }
            case 4: {
                this.specifiedJoinColumnRemoved(notification.getPosition(), (IJoinColumn)notification.getOldValue());
                break;
            }
            case 6: {
                if (notification.getPosition() == -1) {
                    this.specifiedJoinColumnsCleared((List)notification.getOldValue());
                    break;
                }
                this.specifiedJoinColumnsRemoved((int[])notification.getNewValue(), (List)notification.getOldValue());
                break;
            }
            case 1: {
                if (notification.isTouch()) break;
                this.specifiedJoinColumnSet(notification.getPosition(), (IJoinColumn)notification.getOldValue(), (IJoinColumn)notification.getNewValue());
                break;
            }
            case 7: {
                this.specifiedJoinColumnMoved(notification.getOldIntValue(), notification.getPosition(), (IJoinColumn)notification.getNewValue());
                break;
            }
        }
    }

    void specifiedInverseJoinColumnsChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.specifiedInverseJoinColumnAdded(notification.getPosition(), (IJoinColumn)notification.getNewValue());
                break;
            }
            case 5: {
                this.specifiedInverseJoinColumnsAdded(notification.getPosition(), (List)notification.getNewValue());
                break;
            }
            case 4: {
                this.specifiedInverseJoinColumnRemoved(notification.getPosition(), (IJoinColumn)notification.getOldValue());
                break;
            }
            case 6: {
                if (notification.getPosition() == -1) {
                    this.specifiedInverseJoinColumnsCleared((List)notification.getOldValue());
                    break;
                }
                this.specifiedInverseJoinColumnsRemoved((int[])notification.getNewValue(), (List)notification.getOldValue());
                break;
            }
            case 1: {
                if (notification.isTouch()) break;
                this.specifiedInverseJoinColumnSet(notification.getPosition(), (IJoinColumn)notification.getOldValue(), (IJoinColumn)notification.getNewValue());
                break;
            }
            case 7: {
                this.specifiedInverseJoinColumnMoved(notification.getOldIntValue(), notification.getPosition(), (IJoinColumn)notification.getNewValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_JOIN_TABLE;
    }

    @Override
    public EList<IJoinColumn> getJoinColumns() {
        return this.getSpecifiedJoinColumns().isEmpty() ? this.getDefaultJoinColumns() : this.getSpecifiedJoinColumns();
    }

    @Override
    public EList<IJoinColumn> getSpecifiedJoinColumns() {
        if (this.specifiedJoinColumns == null) {
            this.specifiedJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 11);
        }
        return this.specifiedJoinColumns;
    }

    @Override
    public EList<IJoinColumn> getDefaultJoinColumns() {
        if (this.defaultJoinColumns == null) {
            this.defaultJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 12);
        }
        return this.defaultJoinColumns;
    }

    @Override
    public EList<IJoinColumn> getInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumns().isEmpty() ? this.getDefaultInverseJoinColumns() : this.getSpecifiedInverseJoinColumns();
    }

    @Override
    public EList<IJoinColumn> getSpecifiedInverseJoinColumns() {
        if (this.specifiedInverseJoinColumns == null) {
            this.specifiedInverseJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 14);
        }
        return this.specifiedInverseJoinColumns;
    }

    @Override
    public EList<IJoinColumn> getDefaultInverseJoinColumns() {
        if (this.defaultInverseJoinColumns == null) {
            this.defaultInverseJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 15);
        }
        return this.defaultInverseJoinColumns;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return ((InternalEList)this.getSpecifiedJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getDefaultJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getInverseJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getSpecifiedInverseJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getDefaultInverseJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getJoinColumns();
            }
            case 11: {
                return this.getSpecifiedJoinColumns();
            }
            case 12: {
                return this.getDefaultJoinColumns();
            }
            case 13: {
                return this.getInverseJoinColumns();
            }
            case 14: {
                return this.getSpecifiedInverseJoinColumns();
            }
            case 15: {
                return this.getDefaultInverseJoinColumns();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.getSpecifiedJoinColumns().clear();
                this.getSpecifiedJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getDefaultJoinColumns().clear();
                this.getDefaultJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getSpecifiedInverseJoinColumns().clear();
                this.getSpecifiedInverseJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getDefaultInverseJoinColumns().clear();
                this.getDefaultInverseJoinColumns().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.getSpecifiedJoinColumns().clear();
                return;
            }
            case 12: {
                this.getDefaultJoinColumns().clear();
                return;
            }
            case 14: {
                this.getSpecifiedInverseJoinColumns().clear();
                return;
            }
            case 15: {
                this.getDefaultInverseJoinColumns().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return !this.getJoinColumns().isEmpty();
            }
            case 11: {
                return this.specifiedJoinColumns != null && !this.specifiedJoinColumns.isEmpty();
            }
            case 12: {
                return this.defaultJoinColumns != null && !this.defaultJoinColumns.isEmpty();
            }
            case 13: {
                return !this.getInverseJoinColumns().isEmpty();
            }
            case 14: {
                return this.specifiedInverseJoinColumns != null && !this.specifiedInverseJoinColumns.isEmpty();
            }
            case 15: {
                return this.defaultInverseJoinColumns != null && !this.defaultInverseJoinColumns.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IJoinTable.class) {
            switch (derivedFeatureID) {
                case 10: {
                    return 10;
                }
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
                case 13: {
                    return 13;
                }
                case 14: {
                    return 14;
                }
                case 15: {
                    return 15;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IJoinTable.class) {
            switch (baseFeatureID) {
                case 10: {
                    return 10;
                }
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
                case 13: {
                    return 13;
                }
                case 14: {
                    return 14;
                }
                case 15: {
                    return 15;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public IRelationshipMapping relationshipMapping() {
        return (IRelationshipMapping)this.eContainer();
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.updateSpecifiedJoinColumnsFromJava(astRoot);
        this.updateSpecifiedInverseJoinColumnsFromJava(astRoot);
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.setDefaultName((String)defaultsContext.getDefault("joinTable.name"));
    }

    public boolean isSpecified() {
        return this.getMember().containsAnnotation(DECLARATION_ANNOTATION_ADAPTER);
    }

    /*
     * Unable to fully structure code
     */
    private void updateSpecifiedJoinColumnsFromJava(CompilationUnit astRoot) {
        block5: {
            joinColumns = this.getSpecifiedJoinColumns();
            persSize = joinColumns.size();
            javaSize = 0;
            allJavaAnnotationsFound = false;
            i = 0;
            while (i < persSize) {
                joinColumn = (JavaJoinColumn)joinColumns.get(i);
                if (joinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    break;
                }
                joinColumn.updateFromJava(astRoot);
                ++javaSize;
                ++i;
            }
            if (!allJavaAnnotationsFound) ** GOTO lbl29
            while (persSize > javaSize) {
                joinColumns.remove(--persSize);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                joinColumn = this.createJavaJoinColumn(javaSize);
                if (joinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    continue;
                }
                this.getSpecifiedJoinColumns().add((Object)joinColumn);
                joinColumn.updateFromJava(astRoot);
                ++javaSize;
lbl29:
                // 3 sources

                ** while (!allJavaAnnotationsFound)
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateSpecifiedInverseJoinColumnsFromJava(CompilationUnit astRoot) {
        block5: {
            inverseJoinColumns = this.getSpecifiedInverseJoinColumns();
            persSize = inverseJoinColumns.size();
            javaSize = 0;
            allJavaAnnotationsFound = false;
            i = 0;
            while (i < persSize) {
                inverseJoinColumn = (JavaJoinColumn)inverseJoinColumns.get(i);
                if (inverseJoinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    break;
                }
                inverseJoinColumn.updateFromJava(astRoot);
                ++javaSize;
                ++i;
            }
            if (!allJavaAnnotationsFound) ** GOTO lbl29
            while (persSize > javaSize) {
                inverseJoinColumns.remove(--persSize);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                inverseJoinColumn = this.createJavaInverseJoinColumn(javaSize);
                if (inverseJoinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    continue;
                }
                this.getSpecifiedInverseJoinColumns().add((Object)inverseJoinColumn);
                inverseJoinColumn.updateFromJava(astRoot);
                ++javaSize;
lbl29:
                // 3 sources

                ** while (!allJavaAnnotationsFound)
            }
        }
    }

    public void specifiedJoinColumnAdded(int index, IJoinColumn joinColumn) {
        if (((JavaJoinColumn)joinColumn).annotation(this.getMember().astRoot()) == null) {
            this.synchJoinColumnAnnotationsAfterAdd(index + 1);
            ((JavaJoinColumn)joinColumn).newAnnotation();
        }
    }

    public void specifiedJoinColumnsAdded(int index, List<IJoinColumn> joinColumns) {
        if (!joinColumns.isEmpty() && ((JavaJoinColumn)joinColumns.get(0)).annotation(this.getMember().astRoot()) == null) {
            this.synchJoinColumnAnnotationsAfterAdd(index + joinColumns.size());
            for (IJoinColumn joinColumn : joinColumns) {
                ((JavaJoinColumn)joinColumn).newAnnotation();
            }
        }
    }

    public void specifiedJoinColumnRemoved(int index, IJoinColumn joinColumn) {
        ((JavaJoinColumn)joinColumn).removeAnnotation();
        this.synchJoinColumnAnnotationsAfterRemove(index);
    }

    public void specifiedJoinColumnsRemoved(int[] indexes, List<IJoinColumn> joinColumns) {
        for (IJoinColumn joinColumn : joinColumns) {
            ((JavaJoinColumn)joinColumn).removeAnnotation();
        }
        this.synchJoinColumnAnnotationsAfterRemove(indexes[0]);
    }

    public void specifiedJoinColumnsCleared(List<IJoinColumn> joinColumns) {
        for (IJoinColumn joinColumn : joinColumns) {
            ((JavaJoinColumn)joinColumn).removeAnnotation();
        }
    }

    public void specifiedJoinColumnSet(int index, IJoinColumn oldJoinColumn, IJoinColumn newJoinColumn) {
        ((JavaJoinColumn)newJoinColumn).newAnnotation();
    }

    public void specifiedJoinColumnMoved(int sourceIndex, int targetIndex, IJoinColumn joinColumn) {
        EList<IJoinColumn> joinColumns = this.getSpecifiedJoinColumns();
        int begin = Math.min(sourceIndex, targetIndex);
        int end = Math.max(sourceIndex, targetIndex);
        int i = begin;
        while (i-- > end) {
            this.synch((IJoinColumn)joinColumns.get(i), i);
        }
    }

    private void synchJoinColumnAnnotationsAfterAdd(int index) {
        EList<IJoinColumn> joinColumns = this.getSpecifiedJoinColumns();
        int i = joinColumns.size();
        while (i-- > index) {
            this.synch((IJoinColumn)joinColumns.get(i), i);
        }
    }

    private void synchJoinColumnAnnotationsAfterRemove(int index) {
        EList<IJoinColumn> joinColumns = this.getSpecifiedJoinColumns();
        int i = index;
        while (i < joinColumns.size()) {
            this.synch((IJoinColumn)joinColumns.get(i), i);
            ++i;
        }
    }

    public void specifiedInverseJoinColumnAdded(int index, IJoinColumn inverseJoinColumn) {
        if (((JavaJoinColumn)inverseJoinColumn).annotation(this.getMember().astRoot()) == null) {
            this.synchInverseJoinColumnAnnotationsAfterAdd(index + 1);
            ((JavaJoinColumn)inverseJoinColumn).newAnnotation();
        }
    }

    public void specifiedInverseJoinColumnsAdded(int index, List<IJoinColumn> inverseJoinColumns) {
        if (!inverseJoinColumns.isEmpty() && ((JavaJoinColumn)inverseJoinColumns.get(0)).annotation(this.getMember().astRoot()) == null) {
            this.synchInverseJoinColumnAnnotationsAfterAdd(index + inverseJoinColumns.size());
            for (IJoinColumn inverseJoinColumn : inverseJoinColumns) {
                ((JavaJoinColumn)inverseJoinColumn).newAnnotation();
            }
        }
    }

    public void specifiedInverseJoinColumnRemoved(int index, IJoinColumn inverseJoinColumn) {
        ((JavaJoinColumn)inverseJoinColumn).removeAnnotation();
        this.synchInverseJoinColumnAnnotationsAfterRemove(index);
    }

    public void specifiedInverseJoinColumnsRemoved(int[] indexes, List<IJoinColumn> inverseJoinColumns) {
        for (IJoinColumn inverseJoinColumn : inverseJoinColumns) {
            ((JavaJoinColumn)inverseJoinColumn).removeAnnotation();
        }
        this.synchInverseJoinColumnAnnotationsAfterRemove(indexes[0]);
    }

    public void specifiedInverseJoinColumnsCleared(List<IJoinColumn> inverseJoinColumns) {
        for (IJoinColumn inverseJoinColumn : inverseJoinColumns) {
            ((JavaJoinColumn)inverseJoinColumn).removeAnnotation();
        }
    }

    public void specifiedInverseJoinColumnSet(int index, IJoinColumn oldInverseJoinColumn, IJoinColumn newInverseJoinColumn) {
        ((JavaJoinColumn)newInverseJoinColumn).newAnnotation();
    }

    public void specifiedInverseJoinColumnMoved(int sourceIndex, int targetIndex, IJoinColumn inverseJoinColumn) {
        EList<IJoinColumn> inverseJoinColumns = this.getSpecifiedInverseJoinColumns();
        int begin = Math.min(sourceIndex, targetIndex);
        int end = Math.max(sourceIndex, targetIndex);
        int i = begin;
        while (i-- > end) {
            this.synch((IJoinColumn)inverseJoinColumns.get(i), i);
        }
    }

    private void synchInverseJoinColumnAnnotationsAfterAdd(int index) {
        EList<IJoinColumn> inverseJoinColumns = this.getSpecifiedInverseJoinColumns();
        int i = inverseJoinColumns.size();
        while (i-- > index) {
            this.synch((IJoinColumn)inverseJoinColumns.get(i), i);
        }
    }

    private void synchInverseJoinColumnAnnotationsAfterRemove(int index) {
        EList<IJoinColumn> inverseJoinColumns = this.getSpecifiedInverseJoinColumns();
        int i = index;
        while (i < inverseJoinColumns.size()) {
            this.synch((IJoinColumn)inverseJoinColumns.get(i), i);
            ++i;
        }
    }

    private void synch(IJoinColumn joinColumn, int index) {
        ((JavaJoinColumn)joinColumn).moveAnnotation(index);
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (IJoinColumn column : this.getJoinColumns()) {
            result = ((JavaJoinColumn)column).candidateValuesFor(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (IJoinColumn column : this.getInverseJoinColumns()) {
            result = ((JavaJoinColumn)column).candidateValuesFor(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected JavaUniqueConstraint createJavaUniqueConstraint(int index) {
        return JavaUniqueConstraint.createJoinTableUniqueConstraint(new ITable.UniqueConstraintOwner(this), this.getMember(), index);
    }

    @Override
    public IJoinColumn createJoinColumn(int index) {
        return this.createJavaJoinColumn(index);
    }

    private JavaJoinColumn createJavaJoinColumn(int index) {
        return JavaJoinColumn.createJoinTableJoinColumn(new IJoinTable.JoinColumnOwner(this), this.getMember(), index);
    }

    @Override
    public IJoinColumn createInverseJoinColumn(int index) {
        return this.createJavaInverseJoinColumn(index);
    }

    private JavaJoinColumn createJavaInverseJoinColumn(int index) {
        return JavaJoinColumn.createJoinTableInverseJoinColumn(new IJoinTable.InverseJoinColumnOwner(this), this.getMember(), index);
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.getSpecifiedJoinColumns().isEmpty();
    }

    @Override
    public boolean containsSpecifiedInverseJoinColumns() {
        return !this.getSpecifiedInverseJoinColumns().isEmpty();
    }
}

