/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.platform.AbstractJoinColumnContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKeyJoinColumnContext
extends AbstractJoinColumnContext<IPrimaryKeyJoinColumn> {
    public PrimaryKeyJoinColumnContext(IContext parentContext, IPrimaryKeyJoinColumn column) {
        super(parentContext, column);
    }

    @Override
    protected String buildDefaultReferencedColumnName() {
        return this.buildDefaultName();
    }

    @Override
    protected String buildDefaultName() {
        if (((IPrimaryKeyJoinColumn)this.getColumn()).getOwner().joinColumns().size() != 1) {
            return null;
        }
        IEntity entity = (IEntity)((IPrimaryKeyJoinColumn)this.getColumn()).getOwner().getTypeMapping();
        String pkColumnName = entity.parentEntity().primaryKeyColumnName();
        return pkColumnName;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        boolean doContinue = ((IPrimaryKeyJoinColumn)this.column).isConnected();
        if (doContinue && !((IPrimaryKeyJoinColumn)this.column).isResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{((IPrimaryKeyJoinColumn)this.column).getName()}, this.column, ((IPrimaryKeyJoinColumn)this.column).nameTextRange()));
        }
        if (doContinue && !((IPrimaryKeyJoinColumn)this.column).isReferencedColumnResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "PRIMARY_KEY_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME", new String[]{((IPrimaryKeyJoinColumn)this.column).getReferencedColumnName(), ((IPrimaryKeyJoinColumn)this.column).getName()}, this.column, ((IPrimaryKeyJoinColumn)this.column).referencedColumnNameTextRange()));
        }
    }
}

