/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorContentProvider;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorDialog;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorTableLabelProvider;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;
import org.eclipse.wst.internet.monitor.ui.internal.SWTUtil;

public class MonitorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Button displayButton;
    protected Table table;
    protected TableViewer tableViewer;
    protected Button edit;
    protected Button remove;
    protected Button start;
    protected Button stop;
    protected List selection2;

    public MonitorPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(784);
        composite.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.internet.monitor.ui.tmpr0000");
        Label label = new Label(composite, 64);
        label.setText(Messages.preferenceDescription);
        data = new GridData(32);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.displayButton = new Button(composite, 32);
        this.displayButton.setText(Messages.prefShowView);
        this.displayButton.setSelection(MonitorUIPlugin.getShowOnActivityPreference());
        data = new GridData(32);
        data.horizontalSpan = 2;
        data.verticalIndent = 8;
        this.displayButton.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.displayButton, "org.eclipse.wst.internet.monitor.ui.tmpr0002");
        label = new Label(composite, 64);
        label.setText(Messages.monitorList);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalIndent = 8;
        label.setLayoutData((Object)data);
        this.table = new Table(composite, 68354);
        data = new GridData(1808);
        data.widthHint = 350;
        this.table.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.table, "org.eclipse.wst.internet.monitor.ui.tmpr0004");
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        TableColumn statusColumn = new TableColumn(this.table, 0);
        statusColumn.setText(Messages.columnStatus);
        ColumnWeightData colData = new ColumnWeightData(6, 60, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn remoteColumn = new TableColumn(this.table, 0);
        remoteColumn.setText(Messages.columnRemote);
        colData = new ColumnWeightData(12, 120, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn httpColumn = new TableColumn(this.table, 0);
        httpColumn.setText(Messages.columnType);
        colData = new ColumnWeightData(6, 60, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn localColumn = new TableColumn(this.table, 0);
        localColumn.setText(Messages.columnLocal);
        colData = new ColumnWeightData(6, 60, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new MonitorContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MonitorTableLabelProvider());
        this.tableViewer.setInput((Object)"root");
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MonitorPreferencePage.this.setSelection(event.getSelection());
            }
        });
        Composite buttonComp = new Composite(composite, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        data = new GridData(144);
        buttonComp.setLayoutData((Object)data);
        Button add = SWTUtil.createButton(buttonComp, Messages.add);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MonitorDialog dialog = new MonitorDialog(MonitorPreferencePage.this.getShell());
                if (dialog.open() == 1) {
                    return;
                }
                MonitorPreferencePage.this.tableViewer.refresh();
                IMonitor[] monitors = MonitorCore.getMonitors();
                IMonitor monitor = monitors[monitors.length - 1];
                MonitorPreferencePage.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)monitor));
            }
        });
        this.edit = SWTUtil.createButton(buttonComp, Messages.edit);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMonitor monitor = (IMonitor)MonitorPreferencePage.this.getSelection().get(0);
                IMonitorWorkingCopy wc = monitor.createWorkingCopy();
                MonitorDialog dialog = new MonitorDialog(MonitorPreferencePage.this.getShell(), wc);
                if (dialog.open() != 1) {
                    try {
                        MonitorPreferencePage.this.tableViewer.refresh((Object)wc.save());
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.edit.setEnabled(false);
        this.remove = SWTUtil.createButton(buttonComp, Messages.remove);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator iterator = MonitorPreferencePage.this.getSelection().iterator();
                while (iterator.hasNext()) {
                    IMonitor monitor = (IMonitor)iterator.next();
                    try {
                        monitor.delete();
                    }
                    catch (Exception exception) {}
                    MonitorPreferencePage.this.tableViewer.remove((Object)monitor);
                    IMonitor[] monitors = MonitorCore.getMonitors();
                    if (monitors.length <= 0) continue;
                    IMonitor monitor2 = monitors[monitors.length - 1];
                    MonitorPreferencePage.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)monitor2));
                }
            }
        });
        this.remove.setEnabled(false);
        this.start = SWTUtil.createButton(buttonComp, Messages.start);
        data = (GridData)this.start.getLayoutData();
        data.verticalIndent = 9;
        this.start.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator iterator = MonitorPreferencePage.this.getSelection().iterator();
                while (iterator.hasNext()) {
                    IMonitor monitor = (IMonitor)iterator.next();
                    try {
                        monitor.start();
                    }
                    catch (CoreException ce) {
                        MessageDialog.openError((Shell)MonitorPreferencePage.this.getShell(), (String)Messages.errorDialogTitle, (String)ce.getStatus().getMessage());
                    }
                    catch (Exception ce) {
                        MessageDialog.openError((Shell)MonitorPreferencePage.this.getShell(), (String)Messages.errorDialogTitle, (String)ce.getMessage());
                    }
                    MonitorPreferencePage.this.tableViewer.refresh((Object)monitor, true);
                }
                MonitorPreferencePage.this.tableViewer.setSelection(MonitorPreferencePage.this.tableViewer.getSelection());
            }
        });
        this.start.setEnabled(false);
        this.stop = SWTUtil.createButton(buttonComp, Messages.stop);
        this.stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator iterator = MonitorPreferencePage.this.getSelection().iterator();
                while (iterator.hasNext()) {
                    IMonitor monitor = (IMonitor)iterator.next();
                    try {
                        monitor.stop();
                    }
                    catch (Exception exception) {}
                    MonitorPreferencePage.this.tableViewer.refresh((Object)monitor, true);
                }
                MonitorPreferencePage.this.tableViewer.setSelection(MonitorPreferencePage.this.tableViewer.getSelection());
            }
        });
        this.stop.setEnabled(false);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.displayButton.setSelection(MonitorUIPlugin.getDefaultShowOnActivityPreference());
        super.performDefaults();
    }

    public boolean performOk() {
        MonitorUIPlugin.setShowOnActivityPreference(this.displayButton.getSelection());
        MonitorUIPlugin.getInstance().savePluginPreferences();
        return true;
    }

    protected List getSelection() {
        return this.selection2;
    }

    protected void setSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        Iterator iterator = sel.iterator();
        this.selection2 = new ArrayList();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof IMonitor)) continue;
            this.selection2.add(obj);
        }
        if (!this.selection2.isEmpty()) {
            this.remove.setEnabled(true);
            boolean allStopped = true;
            boolean allStarted = true;
            iterator = this.selection2.iterator();
            while (iterator.hasNext()) {
                IMonitor monitor = (IMonitor)iterator.next();
                if (monitor.isRunning()) {
                    allStopped = false;
                    continue;
                }
                allStarted = false;
            }
            this.start.setEnabled(allStopped);
            this.stop.setEnabled(allStarted);
            this.edit.setEnabled(this.selection2.size() == 1 && allStopped);
        } else {
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
            this.start.setEnabled(false);
            this.stop.setEnabled(false);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.internet.monitor.ui.tmpr0000");
    }
}

