/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.annotations.ext;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.annotations.ext.AnnotationDef;
import org.eclipse.stp.sc.common.annotations.ext.IAnnotationInitializer;
import org.eclipse.stp.sc.common.annotations.ext.IAnnotationResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSupportProxy {
    private static final String EXT_ATT_RESOLVER_ID = "resolverId";
    private static final String EXT_ELT_SC_ANN = "annotation";
    private static final String EXT_ELT_RESOLVER = "annotationResolver";
    private static final String EXT_ATT_RESOLVER_CLS = "resolverClass";
    private static Map<String, AnnotationDef> ANN_DECL = new HashMap<String, AnnotationDef>();
    private static Map<String, AnnotationDef> ANN_SIMPLE_DECL = new HashMap<String, AnnotationDef>();
    private static Map<String, IAnnotationResolver> ANN_RESOLVER = new HashMap<String, IAnnotationResolver>();
    private static List<Class<? extends Annotation>> ANN_LIST = new ArrayList<Class<? extends Annotation>>();
    private static final LoggingProxy LOG = LoggingProxy.getlogger(AnnotationSupportProxy.class);
    public static final String EXT_POINT_SC_ANNOTATION_SUPPORT = "org.eclipse.stp.sc.common.AnnotationSupport";

    static {
        AnnotationSupportProxy.loadAnnotationResolver();
        AnnotationSupportProxy.loadAnnotations();
        AnnotationSupportProxy.loadAnnotationClass();
    }

    private AnnotationSupportProxy() {
    }

    private static void loadAnnotationClass() {
        for (AnnotationDef def : ANN_DECL.values()) {
            IAnnotationResolver resolver = ANN_RESOLVER.get(def.resolverId);
            try {
                def.annotation = resolver.loadAnnotationClass(def.className);
                ANN_LIST.add(def.annotation);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                LOG.error((Object)("error when try to load ann class:" + def.className), (Throwable)e);
            }
        }
    }

    private static void loadAnnotationResolver() {
        IConfigurationElement[] extElts;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extElts = reg.getConfigurationElementsFor(EXT_POINT_SC_ANNOTATION_SUPPORT);
        int n = extElts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getName().equals(EXT_ELT_RESOLVER)) {
                try {
                    IAnnotationResolver resolverClass = (IAnnotationResolver)elem.createExecutableExtension(EXT_ATT_RESOLVER_CLS);
                    String resolverId = elem.getAttribute(EXT_ATT_RESOLVER_ID);
                    LOG.debug((Object)("load annotation resolver:" + resolverId));
                    ANN_RESOLVER.put(resolverId, resolverClass);
                }
                catch (CoreException ce) {
                    LOG.error((Object)ce);
                }
            }
            ++n2;
        }
    }

    public static Iterator<Class<? extends Annotation>> getAllAnnotationClasses() {
        return ANN_LIST.iterator();
    }

    public static void loadAnnotations() {
        IConfigurationElement[] extElts;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extElts = reg.getConfigurationElementsFor(EXT_POINT_SC_ANNOTATION_SUPPORT);
        int n = extElts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getName().equals(EXT_ELT_SC_ANN)) {
                AnnotationDef def = new AnnotationDef();
                try {
                    def.loadAnnotation(elem);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    LOG.error((Object)"error during load ann:");
                }
                String clsName = def.className;
                ANN_DECL.put(clsName, def);
                String simpleName = clsName.substring(clsName.lastIndexOf(".") + 1);
                ANN_SIMPLE_DECL.put(simpleName, def);
            }
            ++n2;
        }
    }

    public static boolean verifyNature(String annClassName, String[] natures) {
        AnnotationDef def = ANN_DECL.get(annClassName);
        String definedNature = def.natureId;
        if (definedNature == null) {
            return true;
        }
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.equals(definedNature)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isClassOnly(String annotationName) {
        AnnotationDef def = ANN_DECL.get(annotationName);
        return def.classOnly;
    }

    public static boolean isInterfaceOnly(String annotationName) {
        AnnotationDef def = ANN_DECL.get(annotationName);
        return def.interfaceOnly;
    }

    public static boolean hasAnnotation(String annotationName) {
        boolean ret = ANN_DECL.containsKey(annotationName);
        if (!ret) {
            return ANN_SIMPLE_DECL.containsKey(annotationName);
        }
        return ret;
    }

    public static Class<? extends Annotation> getAnnotationClass(String annotationName) {
        AnnotationDef def = ANN_DECL.get(annotationName);
        if (def == null) {
            def = ANN_SIMPLE_DECL.get(annotationName);
        }
        if (def != null) {
            return def.annotation;
        }
        return null;
    }

    public static Class<? extends Annotation> getAvailableAnnotation(Class annClass) {
        AnnotationDef def = ANN_DECL.get(annClass.getName());
        if (def == null) {
            return null;
        }
        return def.annotation;
    }

    public static IAnnotationInitializer getAvailableAnnotationInitializer(Class annClass) {
        AnnotationDef def = ANN_DECL.get(annClass.getName());
        return def.initializerClass;
    }

    public static List<MemberValuePair> getDefaultAttributes(Class<? extends Annotation> annotationClass, CompilationUnit astRoot, IMember jdtMember, SingleVariableDeclaration jdtMemberParam) {
        IAnnotationInitializer init = AnnotationSupportProxy.getAvailableAnnotationInitializer(annotationClass);
        if (init != null) {
            return init.getDefaultAttributes(annotationClass, astRoot, jdtMember, jdtMemberParam);
        }
        return null;
    }
}

