/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class JarUtils {
    public static String PATH_SEPERATOR = "/";

    public static JarOutputStream createJarOutputStream(String filePath) throws IOException {
        return JarUtils.createJarOutputStream(filePath, null);
    }

    public static JarOutputStream createJarOutputStream(String filePath, String manifestPath) throws IOException {
        File targetFile = new File(filePath);
        FileOutputStream fos = new FileOutputStream(targetFile);
        if (manifestPath == null) {
            return new JarOutputStream((OutputStream)fos, new Manifest());
        }
        FileInputStream fis = new FileInputStream(manifestPath);
        return new JarOutputStream((OutputStream)fos, new Manifest(fis));
    }

    public static void addOneTargetDir(JarOutputStream output, IFolder folderToAdd, String targetPath) throws CoreException, IOException {
        if (folderToAdd != null && folderToAdd.exists()) {
            IResource[] iResourceArray = folderToAdd.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.getType() == 2) {
                    String filePath = targetPath;
                    if (!filePath.equals("") && !filePath.endsWith(PATH_SEPERATOR)) {
                        filePath = String.valueOf(filePath) + PATH_SEPERATOR;
                    }
                    filePath = String.valueOf(filePath) + member.getName();
                    JarUtils.addOneTargetDir(output, (IFolder)member, filePath);
                } else if (member.getType() == 1) {
                    String targetName = member.getName();
                    if (!targetPath.trim().equals("")) {
                        targetName = String.valueOf(targetPath) + PATH_SEPERATOR + member.getName();
                    }
                    JarUtils.addToJar(output, targetName, (IFile)member);
                }
                ++n2;
            }
        }
    }

    public static void addToJar(JarOutputStream output, String fileName, IFile targetFile) throws IOException {
        JarUtils.addToJar(output, fileName, targetFile.getRawLocation().toOSString());
    }

    public static void addToJar(JarOutputStream output, String fileName, String filePath) throws IOException {
        JarEntry jarAdd = new JarEntry(fileName);
        File file = new File(filePath);
        jarAdd.setTime(file.lastModified());
        output.putNextEntry(jarAdd);
        FileInputStream in = new FileInputStream(file);
        byte[] buffer = new byte[10240];
        int read = 0;
        while ((read = in.read(buffer, 0, buffer.length)) > 0) {
            output.write(buffer, 0, read);
        }
        in.close();
    }

    public static boolean unJarFile(String jarFileName, String outputDirectory) throws Exception {
        ZipInputStream in = null;
        try {
            JarEntry jen;
            File target = new File(outputDirectory);
            if (!target.exists()) {
                target.mkdir();
            }
            if (((JarInputStream)(in = new JarInputStream(new FileInputStream(jarFileName)))).getManifest() != null) {
                File manifest = new File(String.valueOf(outputDirectory) + File.separator + "MATA-INF" + File.separator + "MANIFEST.MF");
                if (!manifest.getParentFile().exists()) {
                    JarUtils.createFolder(manifest.getParentFile());
                }
                manifest.createNewFile();
                FileOutputStream out = new FileOutputStream(manifest);
                ((JarInputStream)in).getManifest().write(out);
                out.close();
            }
            while ((jen = ((JarInputStream)in).getNextJarEntry()) != null) {
                if (jen.isDirectory()) {
                    String name = jen.getName();
                    name = name.substring(0, name.length() - 1);
                    File file = new File(String.valueOf(outputDirectory) + File.separator + name);
                    file.mkdir();
                    continue;
                }
                String fname = String.valueOf(outputDirectory) + File.separator + jen.getName().substring(0, jen.getName().indexOf("/"));
                File dt = new File(fname);
                if (!dt.exists()) {
                    dt.mkdir();
                }
                File file = new File(String.valueOf(outputDirectory) + File.separator + jen.getName());
                JarUtils.creatFileForJarEntry(file, (JarInputStream)in);
            }
            in.close();
            return true;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static void creatFileForJarEntry(File file, JarInputStream in) throws Exception {
        int b;
        if (!file.getParentFile().exists()) {
            JarUtils.createFolder(file.getParentFile());
        }
        file.createNewFile();
        FileOutputStream out = new FileOutputStream(file);
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        out.close();
    }

    public static boolean createFolder(File file) {
        if (!file.getParentFile().exists()) {
            JarUtils.createFolder(file.getParentFile());
        }
        if (!file.exists()) {
            file.mkdir();
        }
        return true;
    }
}

