/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.mainengine.api;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.core.PrintHandler;
import org.eclipse.stp.b2j.core.jengine.internal.core.Runner;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.ControllerConnection;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.NonCriticalThreadGroup;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.TransactionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageReader;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageWriter;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerOutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class ControllerConnector
extends ControllerConnection
implements ControllerInterface {
    long clock = 0L;
    Session session;
    MessageReader notify_in;
    MessageWriter notify_out;
    TraceListener tlistener;
    Object tracelisteners_LOCK = new Object();
    ArrayList tracelisteners = new ArrayList();
    protected PrintHandler ph;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTraceListener(TraceListener listener) {
        Object object = this.tracelisteners_LOCK;
        synchronized (object) {
            this.tracelisteners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTraceListener(TraceListener listener) {
        Object object = this.tracelisteners_LOCK;
        synchronized (object) {
            this.tracelisteners.remove(listener);
        }
    }

    public ControllerConnector(SessionAddress session_address, TraceListener nlisten) throws Exception {
        super(0);
        this.tlistener = nlisten;
        this.session = SessionFactory.newSession(session_address, true);
        this.session.begin();
        MultiplexerInputStream mxin = new MultiplexerInputStream(this.session.getInputStream((short)0));
        MultiplexerOutputStream mxout = new MultiplexerOutputStream(this.session.getOutputStream((short)0));
        short server = 0;
        short client = 1;
        short notify = 2;
        this.ts = TransactionFactory.getTransactionServer(mxin.getInputStream(server), mxout.getOutputStream(server), this, new NonCriticalThreadGroup(this), "JEngine API [Controller Server Reader] Thread (" + session_address + ")");
        this.tc = TransactionFactory.getTransactionClient(mxin.getInputStream(client), mxout.getOutputStream(client), new NonCriticalThreadGroup(this), "JEngine API [Controller Client Reader] Thread (" + session_address + ")");
        this.notify_in = new MessageReader(mxin.getInputStream(notify), new NonCriticalThreadGroup(), "JEngine API [Controller Notify Reader] Thread (" + session_address + ")");
        this.notify_out = new MessageWriter(mxout.getOutputStream(notify));
        Message m = this.notify_in.read();
        this.id = m.getType();
        Reader reader = new Reader(this.notify_in, new NonCriticalThreadGroup());
        reader.start();
    }

    public void closeConnection() {
        try {
            this.terminate();
        }
        catch (Exception e) {
            Logger.warning("unable to do controller abort transaction", e);
        }
        try {
            this.session.end();
        }
        catch (Exception exception) {}
    }

    public long setProgram(Program p) throws Exception {
        JARDependency[] deps = p.getDependencies();
        Message m = new Message(1048676);
        m.append(p.writeProgram());
        Message cacheCheck = new Message(1052276);
        int i = 0;
        while (i < deps.length) {
            cacheCheck.append(deps[i].getCacheKey());
            ++i;
        }
        if ((cacheCheck = this.tc.doTransaction(cacheCheck)).getType() != 3701) {
            throw new Exception("Controller check dependencies cache failed " + cacheCheck);
        }
        Message dependencies = new Message();
        int i2 = 0;
        while (i2 < deps.length) {
            String key = (String)cacheCheck.get(i2);
            if (key == null) {
                System.out.println("Client Dependency " + i2 + " of " + deps.length + " - actual JAR");
                dependencies.append(JARDependency.toMessage(deps[i2]));
            } else {
                System.out.println("Client Dependency " + i2 + " of " + deps.length + " - cache key " + key + " (" + deps[i2].size() + ")");
                dependencies.append(key);
            }
            ++i2;
        }
        m.append(dependencies);
        System.out.println("\nSetting Engine Program (" + ((byte[])m.get(0)).length / 1024 + " k)");
        long pt = System.currentTimeMillis();
        m = this.tc.doTransaction(m);
        pt = System.currentTimeMillis() - pt;
        System.out.println("\nSet Engine Program (" + pt / 1000L + "s)");
        if (m.getType() != 101) {
            throw new Exception("Controller set program failed " + m);
        }
        long t = System.currentTimeMillis();
        m = new Message(-2);
        m = this.tc.doTransaction(m);
        t = System.currentTimeMillis() - t;
        m = new Message(1300);
        m.append(t /= 2L);
        this.clock = System.currentTimeMillis();
        m = this.tc.doTransaction(m);
        if (m.getType() != 1301) {
            throw new Exception("Controller sync clock failed " + m);
        }
        return this.clock;
    }

    public void setHeadless(boolean headless) throws Exception {
        Message m = new Message(0x100E10);
        if (headless) {
            m.append(1);
        } else {
            m.append(0);
        }
        m = this.tc.doTransaction(m);
        if (m.getType() != 3601) {
            throw new Exception("Controller set headless failed " + m);
        }
    }

    public void setLogLevel(boolean error, boolean warning, boolean info) throws Exception {
        Logger.PRINT_ERROR = error;
        Logger.PRINT_WARNING = warning;
        Logger.PRINT_INFO = info;
        Message m = new Message(1051876);
        if (error) {
            m.append(1);
        } else {
            m.append(0);
        }
        if (warning) {
            m.append(1);
        } else {
            m.append(0);
        }
        if (info) {
            m.append(1);
        } else {
            m.append(0);
        }
        m = this.tc.doTransaction(m);
        if (m.getType() != 3301) {
            throw new Exception("Controller set log level failed " + m);
        }
    }

    public void notifyRunnerDeath(long id, Runner runner) throws Exception {
        throw new Exception("function not available");
    }

    public void setPrintHandler(PrintHandler ph) {
        this.ph = ph;
    }

    public void trace(Message m) throws Exception {
        throw new Exception("function not available");
    }

    public void print(String s) throws Exception {
        throw new Exception("function not available");
    }

    public void debug(String msg) throws Exception {
        throw new Exception("function not available");
    }

    public ArrayList launchRunnerLocal(int count, String method, ArrayList args) throws Exception {
        throw new Exception("function not available");
    }

    public long getClock() {
        return 0L;
    }

    public String getClientHost() {
        return "localhost";
    }

    class Reader
    extends Thread {
        MessageReader min;
        ThreadGroup tg;

        Reader(MessageReader min) {
            this.min = min;
        }

        Reader(MessageReader min, ThreadGroup tg) {
            super(tg, "JEngine Client [Client Notify Reader] Thread (PORT: unknown)");
            this.min = min;
            this.tg = tg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread th = Thread.currentThread();
            th.setName("JEngine Client [Client Notify Reader] Thread");
            try {
                Message m;
                while (true) {
                    int k;
                    Object object;
                    Object val;
                    int type;
                    if ((type = (m = this.min.read()).getType()) == 1200) {
                        try {
                            val = (Message)m.get(0);
                            ControllerConnector.this.tlistener.trace((Message)val);
                            object = ControllerConnector.this.tracelisteners_LOCK;
                            synchronized (object) {
                                k = 0;
                                while (k < ControllerConnector.this.tracelisteners.size()) {
                                    ((TraceListener)ControllerConnector.this.tracelisteners.get(k)).trace((Message)val);
                                    ++k;
                                }
                            }
                        }
                        catch (Throwable t) {
                            Logger.direct("Error in trace listener - " + t);
                        }
                        continue;
                    }
                    if (type == 1400) {
                        val = (String)m.get(0);
                        ControllerConnector.this.tlistener.print((String)val);
                        object = ControllerConnector.this.tracelisteners_LOCK;
                        synchronized (object) {
                            k = 0;
                            while (k < ControllerConnector.this.tracelisteners.size()) {
                                ((TraceListener)ControllerConnector.this.tracelisteners.get(k)).print((String)val);
                                ++k;
                            }
                        }
                    }
                    if (type != 3200) break;
                    val = (String)m.get(0);
                    ControllerConnector.this.tlistener.debug((String)val);
                    object = ControllerConnector.this.tracelisteners_LOCK;
                    synchronized (object) {
                        k = 0;
                        while (k < ControllerConnector.this.tracelisteners.size()) {
                            ((TraceListener)ControllerConnector.this.tracelisteners.get(k)).debug((String)val);
                            ++k;
                        }
                    }
                }
                throw new IOException("unrecognised message " + m);
            }
            catch (Throwable t) {
                Logger.direct("Notification (Trace+Print) Reader Thread Exited");
                ThreadGroup tg = this.getThreadGroup();
                tg.uncaughtException(this, t);
                return;
            }
        }
    }
}

