/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.engine;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.miniengine.api.DaemonConnector;
import org.eclipse.stp.b2j.core.jengine.internal.utils.EngineListenerTraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.engine.BPELEngineListener;
import org.eclipse.stp.b2j.core.publicapi.program.BPELProgram;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class IndependantLocalBPELEngine {
    BPELProgram program;
    Object running_LOCK = new Object();
    boolean running = false;
    ControllerInterface controller = null;
    Message root_runner_ids = null;

    public IndependantLocalBPELEngine(BPELProgram program) {
        this.program = program;
    }

    public void runProgram() throws Exception {
        this.runProgram(null, false, false, true);
    }

    public void runProgram(boolean terminateEngineOnDisconnect) throws Exception {
        this.runProgram(null, false, false, terminateEngineOnDisconnect);
    }

    public void runProgram(boolean debug, boolean verbose, boolean terminateEngineOnDisconnect) throws Exception {
        this.runProgram(null, debug, verbose, terminateEngineOnDisconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runProgram(BPELEngineListener listener, boolean debug, boolean verbose, boolean terminateEngineOnDisconnect) throws Exception {
        Object object = this.running_LOCK;
        synchronized (object) {
            this.runInternal(this.program, listener, debug, verbose, terminateEngineOnDisconnect, false);
        }
    }

    public void terminate() throws Exception {
        this.controller.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForProgramCompletion() throws Exception {
        Object object = this.running_LOCK;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            int i = 0;
            while (i < this.root_runner_ids.length()) {
                Long id = (Long)this.root_runner_ids.get(i);
                this.controller.joinRunner(id);
                ++i;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            this.controller.closeConnection();
            this.running = false;
        }
    }

    private Program runInternal(BPELProgram bpel_program, BPELEngineListener console, boolean debug, boolean verbose, boolean exitOnDisconnect, boolean validateOnly) throws Exception {
        if (console == null) {
            console = new IgnoredTraceListener();
        }
        EngineListenerTraceListener console_tracel = new EngineListenerTraceListener(console);
        Program prog = (Program)bpel_program.getCompiledData("Program");
        ArrayList program_deps = (ArrayList)bpel_program.getCompiledData("Program Dependencies");
        SessionAddress[] workers = bpel_program.getWorkerHosts();
        SessionAddress[] worker_daemons = bpel_program.getWorkerDaemons();
        int i = 0;
        while (i < workers.length) {
            prog.addHostAddress(workers[i], worker_daemons[i]);
            ++i;
        }
        ArrayList engine_deps = this.fetchAllEngineDependencies(console);
        int i2 = 0;
        while (i2 < program_deps.size()) {
            JARDependency dep = (JARDependency)program_deps.get(i2);
            int k = 0;
            while (k < engine_deps.size()) {
                JARDependency tmp = (JARDependency)engine_deps.get(k);
                if (dep.getFilePath().equals(tmp.getFilePath())) {
                    program_deps.remove(i2--);
                    break;
                }
                ++k;
            }
            ++i2;
        }
        JARDependency[] engine_deps_array = this.dependencyListToArray(engine_deps);
        JARDependency[] program_deps_array = this.dependencyListToArray(program_deps);
        if (engine_deps_array.length > 0 || program_deps_array.length > 0) {
            console.printInfo("");
            console.printInfo("Dependencies:");
        }
        int i3 = 0;
        while (i3 < engine_deps_array.length) {
            console.printInfo("  (Engine Dependency)  " + engine_deps_array[i3].getFilePath());
            ++i3;
        }
        i3 = 0;
        while (i3 < program_deps_array.length) {
            console.printInfo("  (Program Dependency)  " + program_deps_array[i3].getFilePath());
            ++i3;
        }
        if (engine_deps_array.length > 0 || program_deps_array.length > 0) {
            console.printInfo("");
        }
        DaemonConnector daemon = null;
        try {
            console.printInfo("Connecting to mini engine daemon");
            daemon = new DaemonConnector();
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to connect to engine daemon", e);
            return null;
        }
        this.controller = null;
        try {
            console.printInfo("Creating engine instance");
            this.controller = daemon.newEngine(bpel_program.getName(), console_tracel, engine_deps_array, bpel_program.getCoordinatorHost());
            daemon.close();
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to create new engine instance", e);
            return null;
        }
        try {
            console.printInfo("Setting engine program");
            this.controller.setProgram(prog);
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to set engine program in engine instance", e);
            return null;
        }
        try {
            if (!exitOnDisconnect) {
                this.controller.setHeadless(true);
                console.printInfo("Headless mode, engine will continue to run after workbench disconnects");
            }
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to set headless in engine instance", e);
            return null;
        }
        try {
            if (debug) {
                console.printInfo("Debug mode, turning on all engine logging");
                this.controller.setLogLevel(true, true, false);
            } else {
                console.printInfo("Turning on only warning and error logging");
                this.controller.setLogLevel(true, true, false);
            }
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to set log level in engine instance", e);
            return null;
        }
        try {
            console.printInfo("Launching engine program");
            console.printInfo("");
            this.root_runner_ids = this.controller.launchRunner(1, "engine_main", 0, new String[0]);
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to start engine program", e);
            return null;
        }
        this.running = true;
        return null;
    }

    private JARDependency[] dependencyListToArray(ArrayList list) {
        JARDependency[] array = new JARDependency[list.size()];
        list.toArray(array);
        return array;
    }

    private void printFatalProblem(BPELEngineListener console, String description, Exception e) {
        console.printDebug("\n\nERROR: " + description);
        console.printInfo("\nProblem Description:");
        if (e.getMessage() != null) {
            console.printDebug(e.getMessage());
        } else {
            console.printDebug("");
        }
        console.printInfo("\nProblem Details:");
        console.printDebug(IndependantLocalBPELEngine.getStacktrace(e));
    }

    private static String getStacktrace(Throwable t) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(bout);
        t.printStackTrace(print);
        return new String(bout.toByteArray()).replace('\t', ' ');
    }

    private ArrayList fetchAllEngineDependencies(BPELEngineListener console) throws IOException {
        DependencyInfo[] infos = B2jPlatform.getEngineDependencyInfo();
        return this.fetchAllDependencies(console, infos);
    }

    private ArrayList fetchAllDependencies(BPELEngineListener console, DependencyInfo[] infos) throws IOException {
        ArrayList<JARDependency> jardeps = new ArrayList<JARDependency>();
        int i = 0;
        while (i < infos.length) {
            Properties[] props = infos[i].getResources();
            int k = 0;
            while (k < props.length) {
                String path = props[k].getProperty("JAR");
                path = infos[i].getRelativePath(path);
                InputStream in = new FileInputStream(path);
                in = new BufferedInputStream(in);
                byte[] dat = StreamUtils.readAll(in);
                in.close();
                if (path != null) {
                    JARDependency dep = new JARDependency(dat, path);
                    jardeps.add(dep);
                }
                ++k;
            }
            ++i;
        }
        return jardeps;
    }

    private class IgnoredTraceListener
    implements BPELEngineListener {
        private IgnoredTraceListener() {
        }

        public void printInfo(String s) {
        }

        public void printDebug(String s) {
        }

        public void printEngineInfo(String s) {
        }

        public void printEngineDebug(String s) {
        }
    }
}

