/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.services.editpolicy;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.editpolicy.EditPolicyProviderConfiguration;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.jface.util.Assert;

public class EditPolicyService
extends Service
implements IEditPolicyProvider {
    private static final EditPolicyService service = new EditPolicyService();

    static {
        service.configureProviders(DiagramUIPlugin.getPluginId(), "editpolicyProviders");
    }

    public static EditPolicyService getInstance() {
        return service;
    }

    private void execute(IOperation operation) {
        this.execute(ExecutionStrategy.REVERSE, operation);
    }

    public void createEditPolicies(EditPart editPart) {
        this.execute(new CreateEditPoliciesOperation(editPart));
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private EditPolicyProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = EditPolicyProviderConfiguration.parse(element);
            Assert.isNotNull((Object)((Object)this.providerConfiguration));
        }

        public boolean provides(IOperation operation) {
            if (!this.policyInitialized) {
                this.policy = this.getPolicy();
                this.policyInitialized = true;
            }
            if (this.policy != null) {
                return this.policy.provides(operation);
            }
            if (this.provider == null) {
                if (this.isSupportedInExtention(operation)) {
                    this.providerConfiguration = null;
                    return this.getProvider().provides(operation);
                }
                return false;
            }
            return this.getProvider().provides(operation);
        }

        private boolean isSupportedInExtention(IOperation operation) {
            CreateEditPoliciesOperation o = (CreateEditPoliciesOperation)operation;
            return this.providerConfiguration.supports(o.getEditPart());
        }

        public String toString() {
            return this.getElement().getAttribute("class");
        }
    }
}

