/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModelProvider;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.jst.servlet.ui.internal.wizard.AddServletWizardPage;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.jst.servlet.ui.internal.wizard.NewServletClassOptionsWizardPage;
import org.eclipse.jst.servlet.ui.internal.wizard.NewServletClassWizardPage;
import org.eclipse.jst.servlet.ui.internal.wizard.NewWebWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class AddServletWizard
extends NewWebWizard {
    private static final String PAGE_ONE = "pageOne";
    private static final String PAGE_TWO = "pageTwo";
    private static final String PAGE_THREE = "pageThree";

    public AddServletWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(IWebWizardConstants.ADD_SERVLET_WIZARD_WINDOW_TITLE);
        this.setDefaultPageImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("newservlet_wiz"));
    }

    public AddServletWizard() {
        this(null);
    }

    public void doAddPages() {
        NewServletClassWizardPage page1 = new NewServletClassWizardPage(this.getDataModel(), PAGE_ONE, IWebWizardConstants.NEW_JAVA_CLASS_DESTINATION_WIZARD_PAGE_DESC, IWebWizardConstants.ADD_SERVLET_WIZARD_PAGE_TITLE, "jst.web");
        page1.setInfopopID("org.eclipse.jst.servlet.ui.srvw1050");
        this.addPage((IWizardPage)page1);
        AddServletWizardPage page2 = new AddServletWizardPage(this.getDataModel(), PAGE_TWO);
        page2.setInfopopID("org.eclipse.jst.servlet.ui.srvw1100");
        this.addPage((IWizardPage)page2);
        NewServletClassOptionsWizardPage page3 = new NewServletClassOptionsWizardPage(this.getDataModel(), PAGE_THREE, IWebWizardConstants.NEW_JAVA_CLASS_OPTIONS_WIZARD_PAGE_DESC, IWebWizardConstants.ADD_SERVLET_WIZARD_PAGE_TITLE);
        page3.setInfopopID("org.eclipse.jst.servlet.ui.srvw1200");
        this.addPage((IWizardPage)page3);
    }

    protected boolean runForked() {
        return false;
    }

    public boolean canFinish() {
        return this.getDataModel().isValid();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        block8: {
            Object artifactEdit = null;
            try {
                try {
                    String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
                    IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
                    boolean isServlet = this.getDataModel().getBooleanProperty("NewServletClassDataModel.IS_SERVLET_TYPE");
                    if (isServlet) {
                        IJavaProject javaProject = J2EEEditorUtility.getJavaProject((IProject)p);
                        IFile file = (IFile)javaProject.findType(className).getResource();
                        this.openEditor(file);
                        break block8;
                    }
                    IVirtualComponent component = ComponentCore.createComponent((IProject)p);
                    IContainer webContent = component.getRootFolder().getUnderlyingFolder();
                    IFile file = webContent.getFile((IPath)new Path(className));
                    this.openEditor(file);
                }
                catch (Exception cantOpen) {
                    ServletUIPlugin.log(cantOpen);
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        ServletUIPlugin.log((Exception)((Object)e));
                    }
                }
            });
        }
    }

    protected IDataModelProvider getDefaultProvider() {
        return new NewServletClassDataModelProvider();
    }
}

