/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.guiutils;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.ImageContainer;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class IntroductionSection
extends SectionPart {
    private static Logger _log = JSFUICommonPlugin.getLogger(IntroductionSection.class);
    private String _editorId;
    private FormToolkit _toolkit;
    private Composite _textClient;
    private String _helpContextId;
    private String _helpTooltip;

    public IntroductionSection(String editorId, IManagedForm managedForm, FormToolkit toolkit) {
        this(editorId, managedForm, toolkit, null, null);
    }

    public IntroductionSection(String editorId, IManagedForm managedForm, FormToolkit toolkit, String contextId, String helpTooltip) {
        super(managedForm.getForm().getBody(), toolkit, 384);
        super.initialize(managedForm);
        this._editorId = editorId;
        this._toolkit = toolkit;
        this._helpContextId = contextId;
        this._helpTooltip = helpTooltip;
        this._textClient = this._toolkit.createComposite((Composite)this.getSection(), 0);
        this._textClient.setSize(32, 16);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = false;
        rowLayout.justify = true;
        rowLayout.type = 256;
        rowLayout.marginLeft = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginBottom = 0;
        rowLayout.spacing = 0;
        this._textClient.setLayout((Layout)rowLayout);
        this._toolkit.adapt((Control)this._textClient, true, true);
        this.getSection().setTextClient((Control)this._textClient);
        if (this._helpContextId != null) {
            ImageHyperlink helpImage = new ImageHyperlink(this._textClient, 0);
            this._toolkit.adapt((Control)helpImage, true, true);
            helpImage.setImage(JSFUICommonPlugin.getDefault().getImage("help.gif"));
            if (this._helpTooltip != null) {
                helpImage.setToolTipText(this._helpTooltip);
            }
            helpImage.setBackground(this.getSection().getTitleBarGradientBackground());
            helpImage.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IContext context = HelpSystem.getContext((String)IntroductionSection.this._helpContextId);
                    if (context != null) {
                        IHelpResource[] topics = context.getRelatedTopics();
                        if (topics != null && topics.length == 1) {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(topics[0].getHref());
                        } else {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelp(IntroductionSection.this._helpContextId);
                        }
                    }
                }
            });
        }
        Composite client = this._toolkit.createComposite((Composite)this.getSection());
        this.createClient(client, this._toolkit);
        this.getSection().setClient((Control)client);
    }

    private Composite createClient(Composite container, FormToolkit factory) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 20;
        container.setLayout((Layout)layout);
        IConfigurationElement element = this.getExtensions();
        if (element != null) {
            this.setPageDetails(element);
            IConfigurationElement[] children = element.getChildren();
            int ii = 0;
            while (ii < children.length) {
                this.processItems(container, factory, children[ii]);
                ++ii;
            }
        } else {
            this.setText("No Introduction");
            this.setDescription("No Introduction page configuration found in the plugin.xml");
        }
        factory.paintBordersFor(container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, this._helpContextId);
        return container;
    }

    private void setPageDetails(IConfigurationElement element) {
        this.setText(element.getAttribute("name"));
        this.setDescription(element.getAttribute("description"));
    }

    private void processItems(Composite parent, FormToolkit toolkit_, IConfigurationElement element) {
        String hyperlink = element.getAttribute("hyperlink");
        String iconPath = element.getAttribute("icon");
        String text = element.getAttribute("text");
        String heading = element.getAttribute("heading");
        String action = element.getAttribute("hyperlinkaction");
        if (iconPath != null && iconPath.length() > 0 && iconPath != null) {
            String iconName = iconPath.indexOf(47) != -1 ? new Path(iconPath).lastSegment() : iconPath;
            Plugin plugin = Platform.getPlugin((String)element.getDeclaringExtension().getContributor().getName());
            if (plugin instanceof AbstractUIPlugin) {
                ImageRegistry imageRegistry = ((AbstractUIPlugin)plugin).getImageRegistry();
                Image image = imageRegistry.get(iconName);
                if (image == null) {
                    ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getDeclaringExtension().getContributor().getName(), (String)iconPath);
                    imageRegistry.put(iconName, imageDescriptor);
                    image = imageRegistry.get(iconName);
                }
                ImageContainer img = new ImageContainer(parent);
                img.setImage(image);
                TableWrapData td = new TableWrapData();
                td.rowspan = 2;
                img.setLayoutData(td);
            }
        }
        if (heading != null && heading.length() > 0) {
            Label lbl = toolkit_.createLabel(parent, heading);
            lbl.setFont(JFaceResources.getHeaderFont());
        }
        if (hyperlink != null && hyperlink.length() > 0) {
            Hyperlink hypr = toolkit_.createHyperlink(parent, hyperlink, 0);
            if (action != null && action.length() > 0) {
                try {
                    final IAction thisAction = (IAction)element.createExecutableExtension("hyperlinkaction");
                    hypr.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            thisAction.run();
                        }
                    });
                }
                catch (Exception ee) {
                    _log.error("log.IntroductionSection.action.error", hyperlink, ee);
                    JSFUICommonPlugin.getAlerts().detailError(hyperlink, "log.IntroductionSection.action.error", hyperlink, ee);
                }
            }
        }
        if (text != null && text.length() > 0) {
            FormText form = toolkit_.createFormText(parent, false);
            form.setText(text, false, false);
        }
    }

    private IConfigurationElement getExtensions() {
        IConfigurationElement element = null;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jst.jsf.common.ui.introductionPage");
        if (elements.length > 0) {
            int ii = 0;
            while (ii < elements.length) {
                String editorId1 = elements[ii].getDeclaringExtension().getSimpleIdentifier();
                if (this._editorId.equals(editorId1)) {
                    element = elements[ii];
                    break;
                }
                ++ii;
            }
        }
        return element;
    }

    private void setText(String text) {
        this.getSection().setText(text);
    }

    private void setDescription(String text) {
        this.getSection().setDescription(text);
    }

    public void setLayoutData(Object layoutData) {
        this.getSection().setLayoutData(layoutData);
    }
}

