/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.ClassFile;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.DirectoryLoader;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.JarLoader;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.NullLoader;

public class ClassPathLoader {
    public static final FileLoader NULL_LOADER = new NullLoader();
    private File[] files;

    public ClassPathLoader(String classPath) {
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        Vector<File> entries = new Vector<File>();
        while (st.hasMoreTokens()) {
            File file = new File(st.nextToken());
            entries.addElement(file);
        }
        this.files = new File[entries.size()];
        entries.copyInto(this.files);
    }

    public ClassPathLoader(String[] entries) {
        this.files = new File[entries.length];
        int i = 0;
        while (i < entries.length) {
            this.files[i] = new File(entries[i]);
            ++i;
        }
    }

    public ClassPathLoader(File[] entries) {
        this.files = entries;
    }

    public Enumeration loaders() {
        return new LoaderEnumeration();
    }

    public Hashtable getClasses() throws IOException {
        Hashtable<String, ClassFile> map = new Hashtable<String, ClassFile>();
        Enumeration e = this.loaders();
        while (e.hasMoreElements()) {
            FileLoader loader = (FileLoader)e.nextElement();
            System.out.println("Processing " + loader.getFile());
            long t0 = System.currentTimeMillis();
            ClassFile[] classes = loader.getClasses();
            long dt = System.currentTimeMillis() - t0;
            System.out.println("" + classes.length + " classes loaded in " + dt + "ms");
            int j = 0;
            while (j < classes.length) {
                String name = classes[j].getFullName();
                if (!map.containsKey(name)) {
                    map.put(name, classes[j]);
                }
                ++j;
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getCachedStream(InputStream is) throws IOException {
        int n;
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
        bos.reset();
        while ((n = ((InputStream)bis).read(buffer, 0, buffer.length)) != -1) {
            void var4_4;
            bos.write(buffer, 0, (int)var4_4);
        }
        is.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public static interface FileLoader {
        public File getFile();

        public ClassFile[] getClasses() throws IOException;
    }

    private class LoaderEnumeration
    implements Enumeration {
        private int index = 0;

        private LoaderEnumeration() {
        }

        public boolean hasMoreElements() {
            return this.index < ClassPathLoader.this.files.length;
        }

        public Object nextElement() {
            if (this.index >= ClassPathLoader.this.files.length) {
                throw new NoSuchElementException();
            }
            File file = ClassPathLoader.this.files[this.index++];
            if (!file.exists()) {
                return new NullLoader(file);
            }
            if (file.isDirectory()) {
                return new DirectoryLoader(file);
            }
            if (file.getName().endsWith(".zip") || file.getName().endsWith(".jar")) {
                return new JarLoader(file);
            }
            return new NullLoader(file);
        }
    }
}

