/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.classpathdep.ui;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public final class ClasspathDependencyValidatorMarkerResolutions
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        String messageId = null;
        String cpEntryPath = null;
        try {
            messageId = (String)marker.getAttribute("messageId");
            cpEntryPath = (String)marker.getAttribute("groupName");
        }
        catch (CoreException ce) {
            Logger.getLogger((String)"org.eclipse.jst.j2ee.ui").logError((Throwable)ce);
            return new IMarkerResolution[0];
        }
        if (messageId == null || cpEntryPath == null || cpEntryPath.length() == 0) {
            return new IMarkerResolution[0];
        }
        if (!"AppClientProject".equals(messageId)) {
            if ("ClassFolderEntry".equals(messageId)) {
                return new IMarkerResolution[]{new UpdateClasspathDependencyAttributeResolution(cpEntryPath, false)};
            }
            if ("DuplicateArchiveName".equals(messageId)) {
                return new IMarkerResolution[]{new UpdateClasspathDependencyAttributeResolution(cpEntryPath, false)};
            }
            if ("FilteredContainer".equals(messageId)) {
                return new IMarkerResolution[]{new UpdateClasspathDependencyAttributeResolution(cpEntryPath, false)};
            }
            if ("InvalidNonWebRuntimePath".equals(messageId)) {
                return new IMarkerResolution[]{new UpdateClasspathDependencyAttributeResolution(cpEntryPath, false)};
            }
            if ("InvalidWebRuntimePath".equals(messageId)) {
                return new IMarkerResolution[]{new UpdateClasspathDependencyAttributeResolution(cpEntryPath, false)};
            }
            if ("NonTaggedExportedClasses".equals(messageId)) {
                return new IMarkerResolution[]{new UpdateClasspathDependencyAttributeResolution(cpEntryPath, true)};
            }
            if ("NonWebNonExported".equals(messageId)) {
                return new IMarkerResolution[]{new UpdateClasspathDependencyAttributeResolution(cpEntryPath, false)};
            }
            if ("ProjectClasspathEntry".equals(messageId)) {
                return new IMarkerResolution[]{new UpdateClasspathDependencyAttributeResolution(cpEntryPath, false)};
            }
            if (!"RootMappingNonEARWARRef".equals(messageId) && "SourceEntry".equals(messageId)) {
                return new IMarkerResolution[]{new UpdateClasspathDependencyAttributeResolution(cpEntryPath, false)};
            }
        }
        return new IMarkerResolution[0];
    }

    private static IClasspathEntry getClasspathEntryForMarker(IMarker marker, String cpEntryPath) throws CoreException {
        IProject proj = marker.getResource().getProject();
        if (proj != null && proj.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject jProject = JavaCore.create((IProject)proj);
            if (cpEntryPath != null) {
                IClasspathEntry[] rawCp = jProject.getRawClasspath();
                int i = 0;
                while (i < rawCp.length) {
                    if (rawCp[i].getPath().toString().equals(cpEntryPath)) {
                        return rawCp[i];
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String removeClasspathDependencyAttribute;
        public static String addClasspathDependencyAttribute;
        public static String errorDialogTitle;
        public static String errorDialogMessage;

        static {
            Resources.initializeMessages((String)ClasspathDependencyValidatorMarkerResolutions.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class UpdateClasspathDependencyAttributeResolution
    implements IMarkerResolution {
        private final boolean add;
        private final String cpEntryPath;

        public UpdateClasspathDependencyAttributeResolution(String cpEntryPath, boolean add) {
            this.add = add;
            this.cpEntryPath = cpEntryPath;
        }

        public String getLabel() {
            if (this.add) {
                return Resources.addClasspathDependencyAttribute;
            }
            return Resources.removeClasspathDependencyAttribute;
        }

        public void run(IMarker marker) {
            IProject proj = marker.getResource().getProject();
            try {
                IClasspathEntry cpEntry = ClasspathDependencyValidatorMarkerResolutions.getClasspathEntryForMarker(marker, this.cpEntryPath);
                if (this.add) {
                    UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)proj.getName(), (IClasspathEntry)cpEntry);
                } else {
                    UpdateClasspathAttributeUtil.removeDependencyAttribute(null, (String)proj.getName(), (IClasspathEntry)cpEntry);
                }
            }
            catch (CoreException ce) {
                ErrorDialog.openError(null, (String)Resources.errorDialogTitle, (String)Resources.errorDialogMessage, (IStatus)ce.getStatus());
            }
            catch (ExecutionException ee) {
                ErrorDialog.openError(null, (String)Resources.errorDialogTitle, (String)Resources.errorDialogMessage, (IStatus)new Status(4, "org.eclipse.jst.j2ee.ui", 0, ee.getLocalizedMessage(), (Throwable)ee));
            }
        }
    }
}

