/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.j2ee.internal.wizard.EARValidationHelper;
import org.eclipse.jst.j2ee.internal.wizard.ServerTargetComboHelper;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerTargetUIHelper {
    public static String getSelectedServerTargetString(Combo serverTargetCombo) {
        if (serverTargetCombo.getSelectionIndex() != -1) {
            return serverTargetCombo.getItem(serverTargetCombo.getSelectionIndex());
        }
        return null;
    }

    public static int getSelectedServerTargetStringIndex(Combo serverTargetCombo) {
        return serverTargetCombo.getSelectionIndex();
    }

    public static boolean setModuleServerTargetIfNecessary(IProject earProject, IProject moduleProject, Shell shell) {
        return true;
    }

    public static void setServerTarget(Shell shell, IProject project, IRuntime runtime, IProgressMonitor monitor) {
    }

    public static ServerTargetComboHelper getValidServerTargetComboItems(String j2eeType, String selectedVersion) {
        IRuntime[] validServerTargets = ServerUtil.getRuntimes((String)j2eeType, (String)selectedVersion);
        String[] serverTargetList = null;
        if (validServerTargets.length > 0) {
            int serverTargetListSize = validServerTargets.length;
            serverTargetList = new String[serverTargetListSize];
            int i = 0;
            while (i < validServerTargets.length) {
                IRuntime runtime = validServerTargets[i];
                serverTargetList[i] = String.valueOf(runtime.getName()) + " (" + runtime.getRuntimeType().getName() + ")";
                ++i;
            }
        }
        return new ServerTargetComboHelper(Arrays.asList(validServerTargets), serverTargetList);
    }

    public static void runEarValidation(IProject project) {
        try {
            IRunnableWithProgress runnable = EARValidationHelper.createValidationRunnable(project);
            runnable.run(null);
        }
        catch (InterruptedException ie) {
            Logger.getLogger().logError((Throwable)ie);
        }
        catch (InvocationTargetException ite) {
            Logger.getLogger().logError((Throwable)ite);
        }
    }
}

