/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ToggleConnectionLabelsRequest;
import org.eclipse.ui.IWorkbenchPage;

public class ShowConnectionLabelsAction
extends DiagramAction {
    public ShowConnectionLabelsAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public void init() {
        super.init();
        this.setText(DiagramUIActionsMessages.ShowConnectionLabelsAction_label);
        this.setId("showConnectorLabels");
        this.setToolTipText(DiagramUIActionsMessages.ShowConnectionLabelsAction_toolTip);
        this.setImageDescriptor(DiagramUIActionsPluginImages.DESC_SHOW_CONNECTION_LABELS);
        this.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_SHOW_CONNECTION_LABELS_DISABLED);
    }

    protected Request createTargetRequest() {
        return new ToggleConnectionLabelsRequest(true);
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof EditPart)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList connections = new ArrayList();
        if (selection.get(0) instanceof ShapeCompartmentEditPart || selection.get(0) instanceof DiagramEditPart) {
            List diagramConnections = this.getDiagramEditPart().getConnections();
            if (diagramConnections != null && !diagramConnections.isEmpty()) {
                connections.addAll(diagramConnections);
            }
        } else {
            connections.addAll(selection);
        }
        Iterator selectedEPs = connections.iterator();
        ArrayList targetedEPs = new ArrayList();
        while (selectedEPs.hasNext()) {
            EditPart selectedEP = (EditPart)selectedEPs.next();
            targetedEPs.addAll(this.getTargetEditParts(selectedEP));
        }
        return targetedEPs.isEmpty() ? Collections.EMPTY_LIST : targetedEPs;
    }
}

