/**
 * <copyright>
 *
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *   E.D. Willink - Elimination of some shift-reduce conflicts
 *
 * </copyright>
 *
 * $Id: OCLLPGParserprs.java,v 1.10 2007/04/24 23:27:58 cdamus Exp $
 */

package org.eclipse.ocl.internal.parser;

@SuppressWarnings( {"unchecked", "nls"})
public class OCLLPGParserprs
    implements lpg.lpgjavaruntime.ParseTable, OCLLPGParsersym {

    public interface IsKeyword {

        public final static byte isKeyword[] = {0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
            1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1,
            1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0,
            1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1,
            1, 0};
    };

    public final static byte isKeyword[] = IsKeyword.isKeyword;

    public final boolean isKeyword(int index) {
        return isKeyword[index] != 0;
    }

    public interface BaseCheck {

        public final static short baseCheck[] = {0, 1, 1, 1, 1, 1, 1, 0, 1, 1,
            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            2, 4, 1, 0, 1, 1, 2, 1, 1, 1, 7, 4, 4, 0, 1, 3, 0, 1, 5, 5, 5, 3,
            3, 1, 2, 4, 4, 4, 1, 1, 6, 8, 0, 1, 1, 3, 0, 1, 1, 1, 1, 1, 3, 3,
            1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3,
            3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 1, 1, 2, 2, 1, 2,
            2, 4, 6, 1, 1, 1, 1, 3, 2, 2, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            1, 1, 1, 3, 0, 1, 1, 1, 1, 1, 1, 1, 3, 3, 4, 1, 1, 1, 1, 1, 0, 1,
            1, 3, 1, 1, 3, 2, 3, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 2,
            2, 2, 2, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 3, 5, 6, 8, 1,
            3, 5, 3, 0, 1, 1, 1, 1, 1, 4, 4, 0, 1, 1, 3, 1, 1, 3, 3, 1, 1, 5,
            5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
            2, 2, 5, 0, 1, 0, 1, 1, 3, 5, 0, 1, 2, 3, 7, 5, 5, 0, 1, 1, 3, 1,
            1, 3, -118, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, -124, 0, 0, -2, -3, 0, 0, -13, -4, -5, 0, -37, 0, 0, -41, 0, 0,
            -128, 0, 0, -83, -127, 0, 0, 0, 0, 0, 0, 0, -126, 0, 0, -24, -9, 0,
            0, 0, 0, -6, 0, 0, -14, 0, 0, -271, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -91, 0, 0, 0, 0, 0, -10, 0,
            -16, 0, 0, 0, 0, -17, -25, -129, 0, 0, 0, 0, 0, -23, 0, -18, -220,
            0, 0, -272, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, -19, -20, 0, 0, 0, 0, 0, 0, 0, 0, -26, -27, 0, 0, 0, -11, 0,
            -28, 0, -29, -40, -35, -36, -7, 0, 0, -38, -42, 0, 0, 0, -125, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -153, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -69,
            0, -46, 0, -155, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, -149, 0, -156, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, -152, 0, -157, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -222, 0, -158, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -259, 0, -159, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -277,
            0, -160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, -308, 0, -161, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, -310, 0, -162, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -70, 0, -163, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -72, 0, -73, 0, -164, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -74, 0, -75, 0, -165,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -76, 0,
            -77, 0, -166, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, -78, 0, -81, 0, -167, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, -82, 0, -84, 0, -168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, -86, 0, -87, 0, -169, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -88, 0, -89, 0, -170, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -90, 0, -93, 0,
            -171, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -94,
            0, -95, 0, -179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, -97, 0, -96, 0, -182, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, -39, 0, -12, 0, -245, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -98, -99, -100, 0, 0, 0, 0,
            -101, -102, -103, -104, -105, -106, 0, -107, -108, -8, 0, 0, -109,
            -110, -111, 0, 0, -253, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, -112, 0, -260, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, -113, -114, 0, -115, 0, -261, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -116, -117, 0,
            -120, 0, -262, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, -123, -132, 0, -145, 0, -263, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, -146, -150, 0, -151, 0, -264, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -172, -173, 0,
            -176, 0, -265, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, -177, -178, 0, -180, 0, -266, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, -181, -183, 0, -184, 0, -267, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -185, -192, 0,
            -193, 0, -268, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, -194, -195, 0, -196, 0, -269, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, -197, -198, 0, -199, 0, -270, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -200, -201, 0,
            -202, 0, -280, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, -203, 0, -204, 0, -281, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, -205, 0, -207, 0, -121, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -208, 0, -122, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -45, 0, -257, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -313, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -209, -210, 0, 0,
            -211, -212, -213, -214, -218, -219, -223, -224, -225, -226, 0, -30,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -31, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -32, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -33, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -34, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, -49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, -85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, -92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, -174, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, -206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, -215, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -221, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -243, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -244, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -247, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -249, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -301, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -309, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -311, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -319, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -320, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -141, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -142, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -143, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, -144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -136, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, -137, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -138, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, -139, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -140,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -133, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -134, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, -130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -47, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -48, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            -175, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, -1, -304, 0, -246, 0, 0, -21, 0, 0, -227, -228, -229,
            -230, -22, 0, 0, -231, -232, -233, -315, 0, -154, 0, 0, 0, -119,
            -234, -235, -236, -15, 0, -237, 0, 0, -238, -239, -240, -44, 0,
            -50, 0, 0, -148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, -147, 0, 0, 0, 0, 0, -216, -51, 0, 0, 0, 0, 0, 0, 0,
            -52, -53, 0, -54, 0, 0, 0, 0, -241, -55, 0, 0, 0, -217, 0, 0, 0, 0,
            -312, 0, -242, 0, 0, -248, -252, 0, -56, -57, -58, 0, -59, -60, 0,
            -61, 0, 0, -62, -63, -64, -65, -66, -67, 0, 0, -68, 0, -71, -79, 0,
            -80, 0, 0, -186, -187, 0, -188, 0, -189, -190, -191, 0, 0, 0, -250,
            -251, 0, 0, 0, 0, 0, 0, -307, 0, 0, -254, 0, -255, -256, 0, 0, 0,
            0, 0, 0, -258, -273, 0, -274, 0, 0, -275, 0, -276, -278, 0, 0,
            -279, 0, -282, 0, 0, 0, -283, -284, -285, 0, 0, -286, -287, -288,
            -289, -290, -291, 0, -292, -293, -294, -295, -296, -297, -298,
            -299, -300, -302, -305, -306, -314, -316, -317, -318, -321, 0};
    };

    public final static short baseCheck[] = BaseCheck.baseCheck;

    public final int baseCheck(int index) {
        return baseCheck[index];
    }

    public final static short rhs[] = baseCheck;

    public final int rhs(int index) {
        return rhs[index];
    };

    public interface BaseAction {

        public final static char baseAction[] = {73, 73, 73, 73, 73, 73, 73,
            73, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
            6, 6, 75, 75, 59, 74, 76, 76, 60, 60, 51, 51, 51, 54, 58, 58, 61,
            61, 52, 62, 62, 57, 57, 77, 77, 53, 80, 80, 55, 55, 55, 95, 95, 78,
            79, 63, 63, 65, 65, 50, 50, 39, 39, 40, 41, 40, 41, 37, 38, 37, 37,
            37, 38, 38, 38, 35, 36, 35, 36, 35, 36, 33, 34, 33, 34, 33, 34, 33,
            34, 33, 34, 29, 29, 31, 30, 31, 30, 31, 30, 27, 28, 27, 28, 27, 28,
            9, 25, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12,
            12, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 83, 83, 13, 13, 13,
            13, 13, 13, 14, 14, 15, 4, 4, 4, 4, 4, 84, 84, 85, 85, 66, 66, 67,
            67, 67, 17, 17, 17, 17, 17, 16, 20, 21, 22, 23, 24, 24, 18, 19, 81,
            81, 81, 81, 87, 87, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 46,
            46, 46, 89, 89, 44, 44, 44, 69, 64, 64, 47, 47, 47, 47, 49, 48, 90,
            90, 91, 91, 86, 86, 86, 86, 68, 68, 68, 68, 7, 7, 7, 7, 7, 7, 7, 7,
            7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 7, 70, 70, 70, 42, 42, 45, 45,
            43, 43, 26, 92, 92, 93, 93, 32, 82, 82, 71, 71, 72, 72, 56, 56, 56,
            1, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123,
            124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109,
            115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73,
            1819, 1288, 71, 979, 132, 1913, 334, 800, 29, 154, 321, 995, 891,
            422, 1084, 132, 145, 1084, 132, 1334, 1084, 132, 2149, 70, 823,
            132, 4028, 164, 166, 29, 4029, 228, 764, 132, 4028, 688, 1036, 29,
            4027, 228, 187, 1065, 132, 69, 331, 1818, 1821, 161, 132, 4019,
            1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149,
            150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103,
            90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 273, 1288, 71,
            350, 55, 431, 185, 889, 227, 38, 39, 40, 41, 154, 188, 1083, 227,
            271, 119, 120, 1088, 479, 1084, 132, 2193, 186, 189, 190, 619, 497,
            1108, 3, 4089, 4091, 161, 132, 4019, 1150, 596, 4017, 3930, 125,
            126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171,
            172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286,
            85, 1242, 77, 1332, 73, 273, 1288, 71, 1111, 1114, 504, 37, 39, 40,
            41, 414, 51, 1727, 323, 721, 1470, 4063, 271, 321, 327, 74, 429,
            332, 1051, 1116, 1117, 1065, 132, 69, 550, 156, 503, 4092, 4091,
            406, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118,
            123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175,
            109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332,
            73, 259, 1288, 71, 477, 1959, 56, 1915, 406, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91,
            1240, 101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71, 883, 1959,
            690, 2381, 406, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242,
            77, 1332, 73, 259, 1288, 71, 1424, 1959, 690, 2384, 406, 132, 4019,
            1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149,
            150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103,
            90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71,
            222, 1959, 690, 3900, 406, 132, 4019, 1150, 596, 4017, 3930, 125,
            126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171,
            172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286,
            85, 1242, 77, 1332, 73, 259, 1288, 71, 264, 1959, 690, 3901, 406,
            132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123,
            124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109,
            115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73,
            259, 1288, 71, 265, 1959, 690, 3902, 406, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91,
            1240, 101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71, 4072, 1959,
            690, 3903, 406, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242,
            77, 1332, 73, 259, 1288, 71, 67, 1959, 690, 3907, 406, 132, 4019,
            1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149,
            150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103,
            90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71,
            4097, 1959, 690, 3908, 406, 132, 4019, 1150, 596, 4017, 3930, 125,
            126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171,
            172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286,
            85, 1242, 77, 1332, 73, 259, 1288, 71, 4099, 1959, 885, 3909, 406,
            132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123,
            124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109,
            115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73,
            259, 1288, 71, 243, 1959, 938, 3917, 406, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91,
            1240, 101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71, 1085, 1959,
            1113, 3918, 406, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242,
            77, 1332, 73, 259, 1288, 71, 1115, 1959, 1118, 3919, 406, 132,
            4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124,
            148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115,
            1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 259,
            1288, 71, 1126, 1959, 1127, 3922, 406, 132, 4019, 1150, 596, 4017,
            3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152,
            153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240,
            101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71, 695, 1959, 964,
            3925, 406, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338,
            118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174,
            175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77,
            1332, 73, 259, 1288, 71, 859, 1959, 68, 3926, 406, 132, 4019, 1150,
            596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150,
            151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90,
            91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71, 911,
            1959, 1067, 3927, 406, 132, 4019, 1150, 596, 4017, 3930, 125, 126,
            108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172,
            173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85,
            1242, 77, 1332, 73, 259, 1288, 71, 907, 1959, 939, 3978, 406, 132,
            4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124,
            148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115,
            1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 259,
            1288, 71, 1131, 1959, 1142, 3990, 406, 132, 4019, 1150, 596, 4017,
            3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152,
            153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240,
            101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71, 1143, 1959, 1130,
            3993, 406, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338,
            118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174,
            175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77,
            1332, 73, 259, 1288, 71, 402, 1959, 152, 3994, 81, 132, 4019, 1150,
            596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150,
            151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90,
            91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 1819, 1288, 71, 1772,
            1774, 1145, 895, 950, 38, 39, 40, 41, 1148, 1150, 1152, 1155, 1157,
            1159, 32, 1163, 1167, 1065, 132, 69, 1169, 1171, 1173, 165, 166,
            406, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118,
            123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175,
            109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332,
            73, 259, 1288, 71, 478, 1959, 1175, 4066, 477, 132, 4019, 1150,
            596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150,
            151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90,
            91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 202, 1288, 71, 1177,
            1180, 4074, 1185, 4073, 477, 132, 4019, 1150, 596, 4017, 3930, 125,
            126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171,
            172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286,
            85, 1242, 77, 1332, 73, 202, 1288, 71, 1188, 1190, 4074, 1197,
            4078, 477, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338,
            118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174,
            175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77,
            1332, 73, 202, 1288, 71, 1199, 25, 4074, 1161, 4079, 477, 132,
            4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124,
            148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115,
            1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 202,
            1288, 71, 983, 1146, 4074, 1183, 4080, 477, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91,
            1240, 101, 1286, 85, 1242, 77, 1332, 73, 202, 1288, 71, 80, 1192,
            4074, 1203, 4081, 477, 132, 4019, 1150, 596, 4017, 3930, 125, 126,
            108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172,
            173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85,
            1242, 77, 1332, 73, 202, 1288, 71, 653, 1082, 4074, 284, 4082, 477,
            132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123,
            124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109,
            115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73,
            202, 1288, 71, 996, 936, 4074, 1206, 4084, 477, 132, 4019, 1150,
            596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150,
            151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90,
            91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 202, 1288, 71, 1207,
            1209, 4074, 1211, 4085, 477, 132, 4019, 1150, 596, 4017, 3930, 125,
            126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171,
            172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286,
            85, 1242, 77, 1332, 73, 202, 1288, 71, 1213, 1215, 4074, 1217,
            4086, 477, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338,
            118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174,
            175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77,
            1332, 73, 202, 1288, 71, 1220, 1222, 4074, 1224, 4087, 477, 132,
            4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124,
            148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115,
            1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 202,
            1288, 71, 1226, 1228, 4074, 1230, 4088, 406, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91,
            1240, 101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71, 1232, 1959,
            1234, 4094, 406, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242,
            77, 1332, 73, 259, 1288, 71, 1236, 1959, 997, 4095, 335, 132, 4019,
            1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149,
            150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103,
            90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71,
            1031, 1868, 335, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242,
            77, 1332, 73, 259, 1288, 71, 684, 1912, 335, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91,
            1240, 101, 1286, 85, 1242, 77, 1332, 73, 259, 1288, 71, 221, 4068,
            248, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118,
            123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175,
            109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332,
            73, 273, 1288, 71, 928, 1035, 1380, 1426, 972, 234, 236, 325, 1238,
            1241, 1244, 1245, 1248, 1249, 272, 335, 132, 4019, 1150, 596, 4017,
            3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152,
            153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240,
            101, 1286, 85, 1242, 77, 1332, 73, 44, 1288, 71, 335, 132, 4019,
            1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149,
            150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103,
            90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 43, 1288, 71, 335,
            132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123,
            124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109,
            115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73,
            59, 1288, 71, 335, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242,
            77, 1332, 73, 58, 1288, 71, 335, 132, 4019, 1150, 596, 4017, 3930,
            125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153,
            171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101,
            1286, 85, 1242, 77, 1332, 73, 57, 1288, 71, 335, 132, 4019, 1150,
            596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150,
            151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90,
            91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 209, 1288, 71, 335,
            132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123,
            124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109,
            115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73,
            1518, 1288, 71, 335, 132, 4019, 1150, 596, 4017, 3930, 125, 126,
            108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172,
            173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85,
            1242, 77, 1332, 73, 1725, 1288, 71, 335, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91,
            1240, 101, 1286, 85, 1242, 77, 1332, 73, 50, 1288, 71, 335, 132,
            4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124,
            148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115,
            1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 169,
            1288, 71, 335, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242,
            77, 1332, 73, 4055, 1288, 71, 335, 132, 4019, 1150, 596, 4017,
            3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152,
            153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240,
            101, 1286, 85, 1242, 77, 1332, 73, 53, 1288, 71, 335, 132, 4019,
            1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149,
            150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103,
            90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 261, 1288, 71,
            335, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118,
            123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175,
            109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332,
            73, 170, 1288, 71, 335, 132, 4019, 1150, 596, 4017, 3930, 125, 126,
            108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172,
            173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85,
            1242, 77, 1332, 73, 168, 1288, 71, 335, 132, 4019, 1150, 596, 4017,
            3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152,
            153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240,
            101, 1286, 85, 1242, 77, 1332, 73, 210, 1288, 71, 335, 132, 4019,
            1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149,
            150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103,
            90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 260, 1288, 71,
            335, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118,
            123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175,
            109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332,
            73, 4096, 1288, 71, 335, 132, 4019, 1150, 596, 4017, 3930, 125,
            126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171,
            172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286,
            85, 1242, 77, 1332, 73, 52, 1288, 71, 335, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91,
            1240, 101, 1286, 85, 1242, 77, 1332, 73, 4098, 1288, 71, 335, 132,
            4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124,
            148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115,
            1196, 103, 90, 91, 1240, 101, 1286, 85, 1242, 77, 1332, 73, 203,
            1288, 71, 335, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 1286, 85, 1242,
            77, 1332, 73, 4100, 1288, 71, 335, 132, 4019, 1150, 596, 4017,
            3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152,
            153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240,
            101, 1286, 85, 1242, 77, 1332, 73, 204, 1288, 71, 335, 132, 4019,
            1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149,
            150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103,
            90, 91, 1240, 101, 1286, 85, 1242, 77, 2375, 75, 335, 132, 4019,
            1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149,
            150, 151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103,
            90, 91, 1240, 101, 1286, 85, 2376, 83, 335, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91,
            1240, 101, 1286, 85, 2377, 82, 335, 132, 4019, 1150, 596, 4017,
            3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152,
            153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240,
            101, 1286, 85, 2378, 81, 335, 132, 4019, 1150, 596, 4017, 3930,
            125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153,
            171, 172, 173, 174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101,
            2371, 89, 335, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 109, 115, 1196, 103, 90, 91, 1240, 101, 2372, 87, 335,
            132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338, 118, 123,
            124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 109,
            115, 1196, 103, 98, 99, 1240, 101, 335, 132, 4019, 1150, 596, 4017,
            3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151, 152,
            153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 96, 97, 1240,
            101, 335, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 108, 338,
            118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174,
            175, 109, 115, 1196, 103, 94, 95, 1240, 101, 335, 132, 4019, 1150,
            596, 4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150,
            151, 152, 153, 171, 172, 173, 174, 175, 109, 115, 1196, 103, 92,
            93, 1240, 101, 548, 132, 4019, 1150, 596, 4017, 3930, 125, 126,
            108, 338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172,
            173, 174, 175, 109, 115, 2195, 107, 548, 132, 4019, 1150, 596,
            4017, 3930, 125, 126, 108, 338, 118, 123, 124, 148, 149, 150, 151,
            152, 153, 171, 172, 173, 174, 175, 109, 115, 2239, 105, 548, 132,
            4019, 1150, 596, 4017, 3930, 125, 126, 112, 338, 118, 123, 124,
            148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175, 113, 115,
            548, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 110, 338, 118,
            123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173, 174, 175,
            111, 115, 697, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 117,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 697, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 116,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 617, 132, 4019, 1150, 596, 4017, 3930, 125, 126, 116,
            338, 118, 123, 124, 148, 149, 150, 151, 152, 153, 171, 172, 173,
            174, 175, 1046, 1030, 213, 1193, 488, 494, 1065, 132, 69, 1250,
            1253, 1254, 1257, 1065, 132, 69, 1258, 1261, 1262, 1030, 213, 1202,
            488, 494, 2383, 1193, 1265, 1266, 1269, 912, 213, 1270, 488, 494,
            1273, 1274, 1279, 912, 213, 825, 488, 494, 912, 213, 6, 488, 494,
            226, 212, 214, 215, 37, 39, 40, 41, 4, 498, 351, 326, 31, 359, 327,
            414, 499, 1201, 63, 212, 214, 215, 224, 1201, 825, 225, 321, 1,
            1472, 487, 214, 215, 825, 825, 1519, 825, 62, 1378, 214, 215, 1280,
            825, 432, 214, 215, 912, 213, 223, 488, 494, 912, 213, 1283, 488,
            494, 1284, 1287, 2382, 825, 825, 825, 66, 825, 825, 1865, 825,
            1520, 66, 825, 825, 825, 825, 825, 825, 1525, 1526, 825, 1527, 76,
            78, 2379, 245, 2380, 1528, 825, 825, 4057, 825, 2380, 825, 247,
            825, 4060, 214, 215, 825, 825, 275, 214, 215, 1529, 1530, 1532,
            825, 1533, 1537, 1290, 1538, 1292, 1294, 1539, 1586, 1630, 1631,
            1633, 1677, 1296, 1288, 1678, 1298, 1680, 129, 1299, 1724, 1301,
            1081, 4044, 4046, 1302, 1680, 1064, 4047, 4054, 253, 1050, 1305,
            1066, 131, 130, 1034, 1306, 1309, 1310, 1314, 1317, 254, 1318,
            1321, 1322, 1326, 1327, 1330, 1313, 1331, 1333, 1334, 1336, 1339,
            228, 371, 1340, 430, 1343, 4103, 4103};
    };

    public final static char baseAction[] = BaseAction.baseAction;

    public final int baseAction(int index) {
        return baseAction[index];
    }

    public final static char lhs[] = baseAction;

    public final int lhs(int index) {
        return lhs[index];
    };

    public interface TermCheck {

        public final static byte termCheck[] = {0, 0, 1, 0, 3, 4, 5, 6, 7, 8,
            9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0, 25,
            26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 0, 37, 38, 39, 40, 41, 42,
            43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
            60, 61, 62, 63, 64, 65, 66, 0, 68, 0, 70, 4, 5, 0, 1, 0, 1, 0, 1,
            0, 0, 1, 82, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
            18, 19, 20, 21, 22, 23, 0, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
            35, 92, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
            52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 72, 68,
            72, 70, 0, 83, 0, 85, 0, 87, 88, 81, 80, 0, 1, 82, 3, 4, 5, 6, 7,
            8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0,
            25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 0, 37, 38, 39, 40, 41,
            42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
            59, 60, 61, 62, 63, 64, 65, 66, 0, 68, 76, 70, 76, 79, 0, 79, 0, 0,
            4, 5, 4, 5, 90, 0, 1, 0, 0, 0, 0, 1, 89, 3, 4, 5, 6, 7, 8, 9, 10,
            11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0, 25, 26, 27,
            28, 29, 30, 31, 32, 33, 34, 35, 0, 37, 38, 39, 40, 41, 42, 43, 44,
            45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
            62, 63, 64, 65, 66, 72, 68, 72, 70, 72, 36, 0, 94, 0, 3, 0, 81, 4,
            81, 4, 5, 0, 0, 1, 0, 0, 1, 89, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
            13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 75, 25, 26, 27, 28, 29,
            30, 31, 32, 33, 34, 35, 0, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46,
            47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
            64, 65, 66, 0, 68, 73, 70, 0, 1, 74, 3, 4, 5, 6, 7, 8, 9, 10, 11,
            12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0, 25, 26, 27, 28,
            29, 30, 31, 32, 33, 34, 35, 71, 37, 38, 39, 40, 41, 42, 43, 44, 45,
            46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
            63, 64, 65, 66, 0, 68, 73, 70, 0, 1, 0, 3, 4, 5, 6, 7, 8, 9, 10,
            11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 71, 25, 26, 27,
            28, 29, 30, 31, 32, 33, 34, 35, 0, 37, 38, 39, 40, 41, 42, 43, 44,
            45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
            62, 63, 64, 65, 66, 0, 68, 67, 70, 0, 1, 0, 3, 4, 5, 6, 7, 8, 9,
            10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0, 25, 26,
            27, 28, 29, 30, 31, 32, 33, 34, 35, 0, 37, 38, 39, 40, 41, 42, 43,
            44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
            61, 62, 63, 64, 65, 66, 0, 68, 0, 1, 0, 3, 4, 5, 6, 7, 8, 9, 10,
            11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 91, 25, 26, 27,
            28, 29, 30, 31, 32, 33, 34, 35, 0, 37, 38, 39, 40, 41, 42, 43, 44,
            45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
            62, 63, 64, 65, 66, 0, 0, 67, 3, 0, 36, 0, 0, 73, 3, 6, 0, 1, 0, 1,
            82, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
            20, 21, 22, 23, 0, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 80,
            37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
            54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 0, 77, 78, 3,
            4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
            22, 23, 67, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 0, 37, 38,
            39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
            56, 57, 58, 0, 24, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
            16, 17, 18, 19, 20, 21, 22, 23, 0, 25, 26, 27, 28, 29, 30, 31, 32,
            33, 34, 35, 0, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
            50, 51, 52, 53, 54, 55, 56, 57, 58, 0, 0, 2, 0, 4, 5, 6, 0, 0, 0,
            3, 34, 35, 0, 1, 72, 16, 17, 18, 19, 20, 21, 22, 23, 0, 0, 26, 27,
            28, 0, 0, 22, 23, 3, 34, 35, 36, 7, 8, 9, 10, 11, 12, 13, 14, 15,
            0, 18, 19, 20, 21, 26, 27, 28, 0, 1, 0, 0, 1, 29, 30, 31, 32, 33,
            18, 19, 20, 21, 0, 1, 69, 71, 69, 73, 74, 75, 76, 77, 78, 79, 80,
            24, 0, 83, 84, 85, 86, 87, 88, 59, 0, 91, 92, 93, 94, 95, 96, 0,
            16, 17, 3, 0, 1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 26,
            27, 28, 22, 23, 67, 25, 67, 0, 24, 29, 30, 31, 32, 33, 16, 17, 0,
            37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 0, 0, 36,
            3, 0, 0, 0, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 16, 17, 3, 0, 0, 6,
            18, 19, 20, 21, 6, 24, 29, 30, 31, 32, 33, 0, 0, 0, 0, 3, 74, 36,
            75, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 4, 3, 0, 59,
            25, 7, 8, 9, 10, 11, 12, 13, 14, 15, 36, 67, 36, 22, 23, 71, 24,
            24, 0, 25, 74, 0, 24, 0, 0, 0, 0, 0, 0, 73, 74, 71, 76, 77, 78, 79,
            0, 0, 77, 78, 0, 0, 24, 2, 84, 24, 90, 71, 24, 75, 24, 24, 0, 0, 2,
            0, 0, 2, 0, 1, 0, 1, 0, 1, 69, 0, 1, 0, 1, 0, 1, 0, 95, 0, 1, 4,
            36, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 36, 0, 1, 69, 0, 69, 0, 1,
            69, 0, 1, 0, 1, 0, 0, 67, 69, 3, 0, 1, 0, 1, 0, 0, 0, 3, 3, 0, 0,
            2, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 36, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
            0, 1, 0, 1, 0, 1, 0, 1, 0, 36, 2, 0, 96, 36, 0, 0, 2, 2, 0, 0, 0,
            2, 2, 0, 0, 2, 2, 0, 0, 2, 2, 0, 0, 2, 2, 0, 0, 2, 2, 0, 0, 2, 2,
            0, 0, 2, 2, 36, 86, 0, 0, 2, 2, 0, 0, 2, 2, 0, 0, 2, 0, 1, 0, 1, 0,
            1, 0, 1, 0, 0, 2, 0, 0, 4, 2, 0, 0, 2, 2, 0, 0, 2, 2, 0, 0, 67, 2,
            0, 0, 2, 2, 0, 0, 2, 2, 24, 0, 0, 2, 2, 0, 0, 2, 0, 0, 2, 0, 24, 2,
            0, 0, 2, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0,
            0, 0, 0, 0, 0, 0, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    };

    public final static byte termCheck[] = TermCheck.termCheck;

    public final int termCheck(int index) {
        return termCheck[index];
    }

    public interface TermAction {

        public final static char termAction[] = {0, 162, 2638, 45, 1012, 4006,
            4003, 4124, 4240, 4238, 4239, 4241, 4242, 4243, 4244, 4245, 4246,
            4016, 4000, 3998, 3997, 3996, 3979, 4125, 4126, 4103, 4236, 3973,
            3971, 3970, 1148, 1104, 1102, 1058, 1056, 4001, 3866, 4103, 1010,
            4111, 4112, 4113, 4114, 4115, 4116, 4117, 4118, 4119, 4120, 4121,
            4122, 4123, 3816, 4008, 4007, 4009, 4010, 4014, 4011, 3962, 966,
            1194, 4283, 4280, 4282, 4284, 4285, 4287, 76, 598, 114, 2680, 3537,
            3502, 4103, 3928, 178, 255, 255, 29, 4103, 4103, 2638, 2764, 1012,
            4006, 4003, 4124, 4240, 4238, 4239, 4241, 4242, 4243, 4244, 4245,
            4246, 4016, 4000, 3998, 3997, 3996, 3979, 4125, 4126, 4103, 4236,
            3973, 3971, 3970, 1148, 1104, 1102, 1058, 1056, 4001, 3866, 2806,
            1010, 4111, 4112, 4113, 4114, 4115, 4116, 4117, 4118, 4119, 4120,
            4121, 4122, 4123, 3816, 4008, 4007, 4009, 4010, 4014, 4011, 3962,
            966, 1194, 4283, 4280, 4282, 4284, 4285, 4287, 4359, 598, 5260,
            2680, 2, 339, 4103, 347, 47, 423, 335, 2197, 4259, 269, 2638, 2764,
            1012, 4006, 4003, 4124, 4240, 4238, 4239, 4241, 4242, 4243, 4244,
            4245, 4246, 4016, 4000, 3998, 3997, 3996, 3979, 4125, 4126, 4103,
            4236, 3973, 3971, 3970, 1148, 1104, 1102, 1058, 1056, 4001, 3841,
            4103, 1010, 4111, 4112, 4113, 4114, 4115, 4116, 4117, 4118, 4119,
            4120, 4121, 4122, 4123, 3816, 4008, 4007, 4009, 4010, 4014, 4011,
            3962, 966, 1194, 4283, 4280, 4282, 4284, 4285, 4287, 4103, 598,
            3904, 2680, 49, 3897, 80, 49, 79, 4103, 3537, 3502, 3537, 3502,
            492, 183, 30, 255, 4103, 255, 4103, 2638, 4090, 1012, 4006, 4003,
            4124, 4240, 4238, 4239, 4241, 4242, 4243, 4244, 4245, 4246, 4016,
            4000, 3998, 3997, 3996, 3979, 4125, 4126, 4103, 4236, 3973, 3971,
            3970, 1148, 1104, 1102, 1058, 1056, 4001, 3841, 4103, 1010, 4111,
            4112, 4113, 4114, 4115, 4116, 4117, 4118, 4119, 4120, 4121, 4122,
            4123, 3816, 4008, 4007, 4009, 4010, 4014, 4011, 3962, 966, 1194,
            4283, 4280, 4282, 4284, 4285, 4287, 30, 598, 4359, 2680, 4359,
            3058, 4103, 4369, 208, 4247, 78, 2241, 2596, 2285, 3537, 3502, 34,
            4103, 2283, 4103, 4103, 2638, 4090, 1012, 4006, 4003, 4124, 4240,
            4238, 4239, 4241, 4242, 4243, 4244, 4245, 4246, 4016, 4000, 3998,
            3997, 3996, 3979, 4125, 4126, 4033, 4236, 3973, 3971, 3970, 1148,
            1104, 1102, 1058, 1056, 4001, 3841, 4103, 1010, 4111, 4112, 4113,
            4114, 4115, 4116, 4117, 4118, 4119, 4120, 4121, 4122, 4123, 3816,
            4008, 4007, 4009, 4010, 4014, 4011, 3962, 966, 1194, 4283, 4280,
            4282, 4284, 4285, 4287, 36, 598, 325, 2680, 257, 2638, 4102, 1012,
            4006, 4003, 4124, 4240, 4238, 4239, 4241, 4242, 4243, 4244, 4245,
            4246, 4016, 4000, 3998, 3997, 3996, 3979, 4125, 4126, 4103, 4236,
            3973, 3971, 3970, 1148, 1104, 1102, 1058, 1056, 4001, 3841, 3268,
            1010, 4111, 4112, 4113, 4114, 4115, 4116, 4117, 4118, 4119, 4120,
            4121, 4122, 4123, 3816, 4008, 4007, 4009, 4010, 4014, 4011, 3962,
            966, 1194, 4283, 4280, 4282, 4284, 4285, 4287, 4103, 598, 325,
            2680, 4103, 2638, 48, 4077, 4006, 4003, 4124, 4240, 4238, 4239,
            4241, 4242, 4243, 4244, 4245, 4246, 4016, 4000, 3998, 3997, 3996,
            3979, 4125, 4126, 3310, 4236, 3973, 3971, 3970, 1148, 1104, 1102,
            1058, 1056, 4001, 3841, 4103, 1010, 4111, 4112, 4113, 4114, 4115,
            4116, 4117, 4118, 4119, 4120, 4121, 4122, 4123, 3816, 4008, 4007,
            4009, 4010, 4014, 4011, 3962, 966, 1194, 4283, 4280, 4282, 4284,
            4285, 4287, 4103, 598, 332, 2680, 4103, 2638, 4103, 1012, 4006,
            4003, 4124, 4240, 4238, 4239, 4241, 4242, 4243, 4244, 4245, 4246,
            4016, 4000, 3998, 3997, 3996, 3979, 4125, 4126, 4103, 4236, 3973,
            3971, 3970, 1148, 1104, 1102, 1058, 1056, 4001, 3841, 4103, 1010,
            4111, 4112, 4113, 4114, 4115, 4116, 4117, 4118, 4119, 4120, 4121,
            4122, 4123, 3816, 4008, 4007, 4009, 4010, 4014, 4011, 3962, 966,
            1194, 4283, 4280, 4282, 4284, 4285, 4287, 4103, 598, 4103, 2638,
            35, 1012, 4006, 4003, 4124, 4240, 4238, 4239, 4241, 4242, 4243,
            4244, 4245, 4246, 4016, 4000, 3998, 3997, 3996, 3979, 4125, 4126,
            4136, 4236, 3973, 3971, 3970, 1148, 1104, 1102, 1058, 1056, 4001,
            3841, 4103, 1010, 4111, 4112, 4113, 4114, 4115, 4116, 4117, 4118,
            4119, 4120, 4121, 4122, 4123, 3816, 4008, 4007, 4009, 4010, 4014,
            4011, 3962, 966, 1194, 4283, 4280, 4282, 4284, 4285, 4287, 219,
            4103, 329, 322, 4103, 3894, 4103, 4103, 325, 322, 356, 4103, 508,
            4103, 2638, 2974, 1012, 4006, 4003, 4124, 4240, 4238, 4239, 4241,
            4242, 4243, 4244, 4245, 4246, 4016, 4000, 3998, 3997, 3996, 3979,
            4125, 4126, 216, 4236, 3973, 3971, 3970, 1148, 1104, 1102, 1058,
            1056, 4001, 3841, 4279, 1010, 4111, 4112, 4113, 4114, 4115, 4116,
            4117, 4118, 4119, 4120, 4121, 4122, 4123, 3816, 4008, 4007, 4009,
            4010, 4014, 4011, 3962, 966, 1194, 4283, 4280, 4282, 4284, 4285,
            4287, 4103, 1534, 500, 4237, 4006, 4003, 4124, 4240, 4238, 4239,
            4241, 4242, 4243, 4244, 4245, 4246, 4025, 4000, 3998, 3997, 3996,
            3979, 4125, 4126, 329, 4236, 3973, 3971, 3970, 4127, 4128, 4129,
            4130, 4131, 4001, 4023, 207, 4133, 4111, 4112, 4113, 4114, 4115,
            4116, 4117, 4118, 4119, 4120, 4121, 4122, 4123, 4022, 4008, 4007,
            4009, 4010, 4014, 4011, 3962, 4103, 3920, 255, 4237, 4006, 4003,
            4124, 4240, 4238, 4239, 4241, 4242, 4243, 4244, 4245, 4246, 4025,
            4000, 3998, 3997, 3996, 3979, 4125, 4126, 4103, 4236, 3973, 3971,
            3970, 4127, 4128, 4129, 4130, 4131, 4001, 4023, 100, 4133, 1960,
            2147, 2103, 2101, 2056, 2100, 2054, 2053, 2009, 2007, 2006, 1962,
            4123, 4022, 4008, 4007, 4009, 4010, 4014, 4011, 3962, 29, 4103,
            4359, 4103, 4359, 4359, 4359, 4103, 4103, 4103, 1771, 3733, 3704,
            4103, 554, 4359, 4359, 4359, 4359, 4359, 4359, 4359, 4359, 4359,
            4103, 72, 4359, 4359, 4359, 84, 4103, 416, 421, 4247, 4359, 4359,
            4359, 4240, 4238, 4239, 4241, 4242, 4243, 4244, 4245, 4246, 88,
            3671, 3638, 3605, 3572, 3465, 3428, 3391, 155, 1542, 134, 145,
            3955, 4260, 4261, 4262, 4263, 4264, 3671, 3638, 3605, 3572, 4103,
            3912, 276, 4359, 3916, 4359, 4359, 4359, 4359, 4359, 4359, 4359,
            4359, 3933, 102, 4359, 4359, 4359, 4359, 4359, 4359, 496, 74, 4359,
            4359, 4359, 4359, 4359, 4359, 4103, 3789, 3762, 4237, 4103, 3961,
            4124, 4240, 4238, 4239, 4241, 4242, 4243, 4244, 4245, 4246, 46,
            4103, 106, 3465, 3428, 3391, 4125, 4126, 145, 4236, 144, 4103,
            3983, 4127, 4128, 4129, 4130, 4131, 3789, 3762, 4103, 4133, 4111,
            4112, 4113, 4114, 4115, 4116, 4117, 4118, 4119, 4120, 4121, 4122,
            4123, 211, 104, 3058, 4247, 134, 86, 49, 4240, 4238, 4239, 4241,
            4242, 4243, 4244, 4245, 4246, 45, 3789, 3762, 322, 4103, 54, 356,
            3671, 3638, 3605, 3572, 356, 3920, 4260, 4261, 4262, 4263, 4264,
            4103, 68, 4103, 70, 4237, 5, 207, 4034, 4240, 4238, 4239, 4241,
            4242, 4243, 4244, 4245, 4246, 42, 207, 4103, 4103, 28, 3016, 4237,
            4103, 496, 4236, 4240, 4238, 4239, 4241, 4242, 4243, 4244, 4245,
            4246, 3058, 144, 920, 46, 46, 207, 3920, 2386, 4103, 4236, 3, 4103,
            2428, 27, 4103, 26, 4103, 4103, 25, 325, 7, 3184, 48, 1534, 500,
            48, 24, 4103, 1534, 500, 220, 4103, 2470, 4320, 874, 2512, 492,
            3226, 2554, 4041, 408, 2722, 4103, 262, 4321, 4103, 4103, 4230,
            4103, 600, 4103, 646, 4103, 692, 161, 4103, 738, 4103, 784, 4103,
            830, 4103, 3352, 4103, 876, 2848, 644, 4103, 922, 4103, 968, 4103,
            1014, 4103, 1060, 4103, 1106, 4103, 1152, 690, 4103, 1198, 160,
            263, 159, 4103, 1244, 158, 4103, 1290, 4103, 1336, 167, 4103, 318,
            157, 1866, 4103, 1382, 128, 1428, 64, 146, 163, 322, 4247, 4103,
            258, 4224, 8, 782, 19, 1588, 18, 1635, 17, 1682, 16, 1729, 736, 15,
            1776, 14, 1823, 12, 1870, 13, 1917, 11, 1964, 10, 2011, 9, 2058,
            4103, 362, 4103, 435, 4103, 1474, 4062, 65, 2890, 3058, 4103, 4103,
            4353, 4354, 147, 4103, 4103, 4352, 4351, 4103, 4103, 4350, 4349,
            4103, 4103, 4348, 4347, 4103, 4103, 4346, 4345, 4103, 4103, 4343,
            4342, 4103, 4103, 4341, 4340, 4103, 4103, 4339, 4338, 828, 2932,
            4103, 4103, 4337, 4336, 4103, 4103, 4335, 4344, 4103, 4103, 4334,
            4103, 2105, 4103, 2151, 253, 554, 252, 1428, 4103, 4103, 4093,
            4103, 4103, 3142, 4225, 4103, 4103, 4304, 4303, 4103, 4103, 4302,
            4301, 274, 4103, 329, 4300, 4103, 4103, 4299, 4298, 4103, 4103,
            4297, 4296, 3892, 4103, 4103, 4295, 4294, 4103, 270, 4371, 4103,
            4103, 4370, 4103, 3988, 4333, 4103, 4103, 4332, 4308, 4103, 4103,
            4309, 4103, 4103, 4103, 4103, 4103, 4103, 4103, 4103, 4103, 4103,
            4103, 4103, 3910, 4103, 4103, 4103, 4103, 4103, 4103, 4103, 4103,
            2329, 4103, 4103, 4103, 4103, 4103, 4103, 4103, 4103, 4103, 4103,
            4103, 4103, 4103, 3100};
    };

    public final static char termAction[] = TermAction.termAction;

    public final int termAction(int index) {
        return termAction[index];
    }

    public interface Asb {

        public final static char asb[] = {0, 374, 181, 69, 173, 174, 77, 77,
            77, 382, 383, 156, 349, 156, 180, 52, 88, 88, 88, 88, 88, 77, 77,
            158, 336, 342, 287, 162, 357, 357, 92, 92, 92, 92, 92, 88, 88, 146,
            415, 414, 333, 146, 177, 92, 52, 247, 156, 94, 94, 92, 406, 406,
            406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406, 406,
            406, 406, 406, 406, 250, 250, 298, 298, 252, 296, 296, 296, 296,
            296, 297, 297, 344, 357, 300, 304, 92, 306, 312, 308, 317, 314,
            156, 92, 340, 248, 248, 441, 346, 248, 357, 357, 357, 357, 357,
            357, 357, 357, 357, 357, 357, 357, 357, 357, 357, 357, 357, 357,
            357, 1, 156, 357, 92, 92, 255, 124, 183, 103, 103, 146, 146, 93,
            93, 352, 93, 93, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 354, 356,
            247, 52, 156, 347, 346, 156, 183, 247, 183, 183, 183, 183, 183,
            183, 183, 183, 183, 183, 183, 183, 183, 183, 183, 183, 183, 366,
            359, 92, 4, 365, 365, 363, 183, 368, 368, 183, 254, 248, 441, 406,
            406, 406, 298, 297, 299, 298, 298, 298, 298, 298, 298, 298, 298,
            298, 298, 298, 298, 357, 357, 92, 304, 304, 308, 308, 314, 312,
            312, 312, 92, 247, 52, 248, 441, 174, 92, 156, 248, 248, 371, 248,
            248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
            248, 248, 248, 92, 92, 2, 156, 92, 248, 92, 299, 299, 248, 183,
            357, 357, 255, 92, 255, 156, 92, 92, 92, 92, 92, 92, 92, 92, 92,
            92, 92, 90, 90, 409, 248, 354, 88, 156, 411, 248, 183, 183, 368,
            74, 248, 293, 417, 248, 248, 248, 248, 248, 248, 248, 248, 248,
            248, 248, 440, 441, 248, 92, 88, 92, 386, 248, 248, 299, 156, 92,
            156, 92, 52, 91, 444, 51, 294, 248, 294, 92, 92, 248};
    };

    public final static char asb[] = Asb.asb;

    public final int asb(int index) {
        return asb[index];
    }

    public interface Asr {

        public final static byte asr[] = {0, 80, 70, 68, 60, 38, 39, 40, 41,
            42, 43, 44, 45, 46, 47, 48, 49, 50, 6, 22, 23, 25, 66, 37, 62, 16,
            63, 61, 64, 65, 56, 57, 55, 54, 52, 53, 5, 34, 17, 18, 19, 20, 21,
            26, 27, 28, 58, 1, 35, 51, 82, 4, 8, 9, 7, 10, 11, 12, 13, 14, 15,
            59, 29, 30, 31, 32, 33, 3, 0, 2, 36, 96, 74, 24, 71, 84, 0, 25, 3,
            8, 9, 7, 10, 11, 12, 13, 14, 15, 24, 0, 2, 89, 70, 68, 60, 66, 62,
            63, 61, 64, 65, 59, 1, 56, 57, 55, 54, 52, 53, 4, 5, 34, 16, 17,
            18, 19, 20, 21, 26, 27, 28, 58, 35, 51, 38, 39, 40, 41, 42, 43, 44,
            45, 46, 47, 48, 49, 50, 6, 22, 23, 29, 30, 31, 32, 33, 37, 25, 8,
            9, 7, 10, 11, 12, 13, 14, 15, 3, 0, 91, 73, 67, 0, 4, 2, 80, 71,
            36, 84, 77, 78, 96, 6, 67, 74, 23, 22, 0, 76, 79, 91, 73, 74, 0,
            70, 60, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 6, 22,
            23, 29, 30, 31, 32, 33, 8, 9, 7, 10, 11, 12, 13, 14, 15, 25, 66,
            37, 62, 16, 63, 61, 64, 65, 59, 56, 57, 55, 54, 52, 53, 4, 5, 34,
            17, 18, 19, 20, 21, 26, 27, 28, 58, 1, 35, 51, 68, 3, 2, 0, 69, 0,
            81, 72, 67, 34, 35, 16, 17, 18, 19, 20, 21, 5, 75, 83, 85, 86, 87,
            88, 76, 77, 78, 73, 91, 79, 92, 93, 94, 26, 27, 28, 95, 6, 22, 23,
            1, 2, 80, 84, 96, 74, 4, 36, 71, 0, 69, 81, 1, 72, 87, 88, 83, 85,
            16, 17, 34, 35, 18, 19, 20, 21, 4, 5, 26, 27, 28, 2, 80, 75, 71,
            36, 84, 86, 76, 79, 92, 93, 94, 96, 22, 23, 95, 73, 91, 74, 77, 78,
            6, 0, 24, 1, 76, 79, 67, 0, 36, 96, 0, 74, 90, 0, 92, 0, 4, 0, 24,
            1, 0, 80, 36, 86, 0, 24, 4, 36, 80, 0, 75, 36, 0, 2, 67, 0, 22, 23,
            73, 90, 77, 78, 6, 3, 74, 76, 79, 0, 77, 78, 6, 8, 9, 7, 10, 11,
            12, 13, 14, 15, 59, 29, 30, 31, 32, 33, 3, 0, 1, 72, 0, 93, 0, 22,
            23, 74, 73, 91, 0, 71, 67, 34, 35, 16, 17, 18, 19, 4, 20, 21, 5, 1,
            81, 83, 85, 72, 87, 88, 26, 27, 28, 95, 24, 2, 36, 0, 94, 0};
    };

    public final static byte asr[] = Asr.asr;

    public final int asr(int index) {
        return asr[index];
    }

    public interface Nasb {

        public final static byte nasb[] = {0, 78, 39, 39, 39, 39, 17, 17, 17,
            39, 39, 38, 32, 1, 19, 37, 39, 39, 39, 39, 39, 17, 17, 26, 15, 24,
            39, 39, 39, 39, 35, 35, 35, 35, 35, 39, 39, 52, 39, 19, 28, 52, 39,
            35, 37, 40, 84, 35, 35, 35, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88,
            88, 88, 88, 88, 88, 88, 88, 88, 88, 39, 39, 88, 39, 39, 39, 39, 39,
            39, 39, 88, 88, 39, 39, 4, 39, 35, 39, 39, 39, 39, 39, 21, 35, 39,
            39, 39, 39, 30, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
            39, 39, 39, 39, 39, 39, 39, 35, 86, 39, 35, 35, 39, 8, 35, 11, 7,
            52, 52, 72, 72, 39, 66, 66, 54, 54, 60, 60, 60, 60, 42, 48, 48, 48,
            39, 39, 90, 37, 84, 39, 39, 84, 35, 38, 35, 35, 35, 35, 35, 35, 35,
            35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 39, 39, 35, 35, 39, 39, 39,
            35, 39, 39, 35, 39, 39, 39, 88, 88, 88, 88, 88, 88, 39, 39, 39, 39,
            39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 35, 39, 39, 39, 39, 39, 39,
            39, 39, 35, 90, 37, 39, 39, 81, 35, 84, 39, 39, 39, 39, 39, 39, 39,
            39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 35, 35, 35, 83,
            35, 39, 35, 88, 88, 39, 35, 39, 39, 39, 35, 39, 84, 34, 34, 34, 34,
            34, 34, 34, 34, 34, 34, 34, 35, 35, 39, 39, 39, 39, 84, 39, 39, 35,
            35, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39,
            39, 39, 39, 35, 39, 35, 37, 39, 39, 88, 84, 35, 84, 35, 37, 35, 39,
            37, 39, 39, 39, 35, 35, 39};
    };

    public final static byte nasb[] = Nasb.nasb;

    public final int nasb(int index) {
        return nasb[index];
    }

    public interface Nasr {

        public final static char nasr[] = {0, 3, 79, 0, 81, 82, 0, 87, 2, 6, 0,
            2, 6, 8, 0, 80, 0, 50, 0, 51, 0, 78, 77, 0, 57, 0, 60, 0, 55, 0,
            93, 0, 59, 0, 44, 2, 5, 4, 3, 0, 91, 0, 3, 2, 5, 4, 38, 0, 5, 3, 4,
            36, 2, 0, 3, 2, 5, 4, 34, 0, 5, 2, 3, 4, 30, 0, 5, 2, 3, 4, 28, 0,
            3, 2, 5, 4, 25, 0, 60, 75, 57, 58, 0, 69, 44, 0, 86, 0, 42, 0, 65,
            0};
    };

    public final static char nasr[] = Nasr.nasr;

    public final int nasr(int index) {
        return nasr[index];
    }

    public interface TerminalIndex {

        public final static char terminalIndex[] = {0, 11, 12, 98, 7, 10, 55,
            86, 87, 88, 89, 90, 92, 93, 94, 95, 3, 4, 5, 6, 8, 9, 56, 57, 20,
            34, 46, 47, 48, 61, 62, 63, 64, 65, 1, 2, 19, 58, 66, 67, 68, 69,
            70, 71, 72, 73, 74, 75, 76, 77, 85, 49, 78, 79, 80, 81, 82, 83, 84,
            91, 30, 31, 32, 33, 53, 54, 96, 21, 51, 13, 42, 18, 25, 38, 97, 16,
            35, 36, 37, 41, 14, 15, 99, 17, 22, 23, 24, 26, 27, 28, 39, 40, 43,
            44, 45, 50, 52, 59, 60, 100};
    };

    public final static char terminalIndex[] = TerminalIndex.terminalIndex;

    public final int terminalIndex(int index) {
        return terminalIndex[index];
    }

    public interface NonterminalIndex {

        public final static char nonterminalIndex[] = {0, 0, 112, 109, 139,
            106, 107, 0, 137, 132, 134, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 133, 0, 130, 131, 127, 128, 129, 0, 125, 126, 123, 124, 121,
            122, 114, 120, 0, 0, 138, 105, 0, 145, 113, 0, 0, 0, 111, 0, 0, 0,
            103, 150, 102, 104, 108, 110, 0, 0, 0, 0, 119, 141, 0, 143, 146, 0,
            0, 149, 0, 0, 101, 0, 115, 116, 117, 118, 135, 136, 0, 0, 140, 142,
            144, 0, 0, 0, 147, 0, 148, 0, 0};
    };

    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;

    public final int nonterminalIndex(int index) {
        return nonterminalIndex[index];
    }

    public interface ScopePrefix {

        public final static char scopePrefix[] = {178, 13, 206, 287, 186, 1, 8,
            53, 58, 63, 68, 73, 78, 83, 88, 93, 98, 103, 108, 113, 118, 123,
            128, 133, 138, 143, 148, 153, 158, 22, 163, 167, 226, 230, 234,
            238, 242, 246, 250, 254, 258, 262, 266, 270, 276, 293, 40, 47, 171,
            212, 280, 47, 196, 196, 284, 31, 219, 297, 297, 305, 305, 313, 313,
            313, 313, 327, 327, 335, 335, 335, 219};
    };

    public final static char scopePrefix[] = ScopePrefix.scopePrefix;

    public final int scopePrefix(int index) {
        return scopePrefix[index];
    }

    public interface ScopeSuffix {

        public final static char scopeSuffix[] = {6, 20, 6, 6, 192, 6, 6, 6, 6,
            6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 27, 6,
            6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 274, 274, 6, 44, 51, 175, 216,
            51, 51, 192, 200, 6, 34, 216, 299, 302, 307, 310, 315, 318, 321,
            324, 329, 332, 337, 340, 343, 221};
    };

    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;

    public final int scopeSuffix(int index) {
        return scopeSuffix[index];
    }

    public interface ScopeLhs {

        public final static char scopeLhs[] = {89, 32, 89, 10, 89, 82, 82, 8,
            7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 68, 68,
            32, 48, 49, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 16, 15, 10,
            26, 70, 44, 46, 12, 12, 89, 89, 11, 32, 46, 28, 28, 30, 30, 34, 34,
            34, 34, 36, 36, 38, 38, 38, 46};
    };

    public final static char scopeLhs[] = ScopeLhs.scopeLhs;

    public final int scopeLhs(int index) {
        return scopeLhs[index];
    }

    public interface ScopeLa {

        public final static byte scopeLa[] = {2, 94, 2, 2, 71, 2, 2, 2, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 93, 2, 2,
            2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 80, 80, 2, 96, 75, 4, 71, 75, 75,
            71, 84, 2, 92, 71, 17, 16, 35, 34, 21, 20, 19, 18, 5, 4, 28, 27,
            26, 36};
    };

    public final static byte scopeLa[] = ScopeLa.scopeLa;

    public final int scopeLa(int index) {
        return scopeLa[index];
    }

    public interface ScopeStateSet {

        public final static byte scopeStateSet[] = {2, 15, 2, 8, 2, 4, 4, 7, 6,
            6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 1, 1, 15, 92,
            92, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 11, 1, 100, 80, 8, 8,
            2, 2, 8, 15, 80, 13, 13, 15, 15, 19, 19, 19, 19, 21, 21, 24, 24,
            24, 80};
    };

    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;

    public final int scopeStateSet(int index) {
        return scopeStateSet[index];
    }

    public interface ScopeRhs {

        public final static char scopeRhs[] = {0, 170, 1, 101, 88, 0, 12, 0,
            170, 1, 101, 87, 0, 138, 93, 138, 92, 138, 70, 0, 45, 0, 138, 92,
            138, 70, 0, 44, 114, 45, 0, 138, 70, 0, 43, 114, 44, 114, 45, 0,
            191, 143, 68, 0, 52, 114, 0, 142, 81, 101, 0, 16, 0, 144, 1, 141,
            105, 0, 144, 1, 141, 28, 0, 144, 1, 141, 27, 0, 144, 1, 141, 26, 0,
            144, 1, 141, 21, 0, 144, 1, 141, 20, 0, 144, 1, 141, 19, 0, 144, 1,
            141, 18, 0, 144, 1, 141, 17, 0, 144, 1, 141, 16, 0, 144, 1, 141,
            34, 0, 144, 1, 141, 5, 0, 144, 1, 141, 4, 0, 144, 1, 141, 53, 0,
            144, 1, 141, 52, 0, 144, 1, 141, 54, 0, 144, 1, 141, 55, 0, 144, 1,
            141, 57, 0, 144, 1, 141, 56, 0, 144, 1, 141, 101, 0, 144, 1, 141,
            51, 0, 144, 1, 141, 35, 0, 189, 1, 59, 0, 146, 1, 103, 0, 146, 24,
            3, 0, 7, 114, 0, 138, 71, 143, 84, 143, 1, 38, 0, 143, 84, 143, 1,
            38, 0, 18, 114, 12, 0, 143, 1, 38, 0, 22, 105, 18, 114, 12, 0, 138,
            71, 143, 1, 38, 0, 143, 36, 143, 0, 18, 114, 0, 143, 0, 19, 105,
            18, 114, 0, 145, 1, 49, 0, 145, 1, 48, 0, 145, 1, 47, 0, 145, 1,
            46, 0, 145, 1, 45, 0, 145, 1, 44, 0, 145, 1, 42, 0, 145, 1, 43, 0,
            145, 1, 41, 0, 145, 1, 40, 0, 145, 1, 39, 0, 185, 69, 59, 0, 14, 0,
            183, 69, 103, 0, 142, 81, 104, 0, 138, 1, 0, 144, 1, 101, 67, 102,
            0, 144, 1, 60, 0, 126, 0, 4, 133, 0, 3, 133, 0, 130, 0, 2, 131, 0,
            1, 131, 0, 132, 0, 9, 128, 0, 8, 128, 0, 6, 128, 0, 5, 128, 0, 134,
            0, 10, 126, 0, 7, 126, 0, 136, 0, 48, 124, 0, 47, 124, 0, 46, 124,
            0};
    };

    public final static char scopeRhs[] = ScopeRhs.scopeRhs;

    public final int scopeRhs(int index) {
        return scopeRhs[index];
    }

    public interface ScopeState {

        public final static char scopeState[] = {0, 347, 339, 0, 338, 0, 339,
            347, 3866, 3841, 3816, 3789, 3762, 3733, 3704, 3671, 3638, 3605,
            3572, 3537, 3502, 3465, 3428, 3391, 3310, 3268, 2329, 3226, 3184,
            3142, 3100, 2151, 2105, 435, 362, 2285, 1542, 3058, 3016, 1474,
            2974, 2932, 2890, 2848, 2806, 1428, 1382, 2764, 1336, 1290, 1244,
            1198, 1152, 1106, 1060, 1014, 968, 922, 876, 830, 784, 738, 692,
            646, 600, 554, 3352, 508, 2241, 2197, 276, 2722, 2680, 2638, 2596,
            2554, 2512, 2470, 2428, 2386, 2058, 2011, 1964, 1917, 1870, 1823,
            1776, 1729, 1682, 1635, 1588, 0, 3910, 3988, 3892, 3983, 3933,
            3928, 3920, 0, 920, 874, 828, 2058, 2011, 1964, 1917, 1870, 1823,
            1776, 1729, 1682, 1635, 1588, 782, 3894, 736, 3961, 690, 644, 3955,
            3916, 598, 2283, 3891, 0};
    };

    public final static char scopeState[] = ScopeState.scopeState;

    public final int scopeState(int index) {
        return scopeState[index];
    }

    public interface InSymb {

        public final static char inSymb[] = {0, 0, 172, 3, 157, 160, 6, 78, 77,
            156, 161, 90, 174, 73, 159, 24, 22, 23, 149, 149, 149, 79, 76, 102,
            178, 102, 146, 102, 103, 59, 24, 24, 24, 24, 24, 149, 149, 67, 175,
            159, 179, 67, 156, 4, 1, 1, 68, 51, 35, 1, 105, 58, 28, 27, 26, 21,
            20, 19, 18, 17, 34, 5, 4, 53, 52, 54, 55, 57, 56, 103, 59, 16, 37,
            3, 33, 32, 31, 30, 29, 104, 101, 102, 60, 109, 126, 70, 130, 134,
            132, 139, 136, 24, 24, 101, 146, 189, 190, 143, 138, 141, 141, 141,
            141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141, 141,
            141, 141, 141, 69, 69, 141, 81, 81, 141, 67, 1, 85, 83, 88, 87, 17,
            16, 138, 35, 34, 5, 4, 21, 20, 19, 18, 95, 28, 27, 26, 177, 3, 1,
            24, 36, 191, 192, 36, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
            1, 1, 1, 1, 183, 138, 82, 35, 184, 185, 3, 1, 142, 142, 1, 101,
            144, 142, 51, 35, 16, 105, 101, 105, 38, 49, 48, 47, 46, 45, 44,
            42, 43, 41, 40, 39, 101, 101, 92, 126, 126, 132, 132, 136, 134,
            134, 134, 4, 1, 24, 162, 164, 146, 96, 36, 144, 182, 102, 144, 144,
            144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144, 144,
            144, 144, 86, 82, 36, 36, 4, 144, 36, 75, 75, 144, 1, 141, 141,
            141, 81, 141, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 138, 162,
            146, 2, 36, 157, 144, 1, 1, 142, 143, 145, 143, 3, 145, 145, 145,
            145, 145, 145, 145, 145, 145, 145, 170, 89, 171, 170, 93, 2, 4, 24,
            144, 144, 75, 84, 71, 36, 71, 24, 36, 138, 24, 143, 138, 143, 71,
            71, 138};
    };

    public final static char inSymb[] = InSymb.inSymb;

    public final int inSymb(int index) {
        return inSymb[index];
    }

    public interface Name {

        public final static String name[] = {"", "+", "-", "*", "/", ">", "<",
            "=", ">=", "<=", "<>", "(", ")", "{", "}", "[", "]", "->", "|",
            ",", ":", "::", ";", ".", "..", "@pre", "^", "^^", "?", "$empty",
            "NUMERIC_OPERATION", "STRING_LITERAL", "INTEGER_LITERAL",
            "REAL_LITERAL", "self", "inv", "pre", "post", "context", "package",
            "endpackage", "def", "if", "then", "else", "endif", "and", "or",
            "xor", "not", "implies", "let", "in", "true", "false", "body",
            "derive", "init", "null", "attr", "oper", "Set", "Bag", "Sequence",
            "Collection", "OrderedSet", "iterate", "forAll", "exists",
            "isUnique", "any", "one", "collect", "select", "reject",
            "collectNested", "sortedBy", "closure", "oclIsKindOf",
            "oclIsTypeOf", "oclAsType", "oclIsNew", "oclIsUndefined",
            "oclIsInvalid", "oclIsInState", "allInstances", "String",
            "Integer", "UnlimitedNatural", "Real", "Boolean", "Tuple",
            "OclAny", "OclVoid", "Invalid", "OclMessage", "OclInvalid",
            "EOF_TOKEN", "IDENTIFIER", "INTEGER_RANGE_START", "ERROR_TOKEN",
            "packageDeclarationCSm", "invOrDefCS", "prePostOrBodyDeclCS",
            "initOrDerValueCS", "variableCS", "keywordAsIdentifier1",
            "keywordAsIdentifier", "packageDeclarationCS", "pathNameCS",
            "contextDeclCSm", "contextDeclCS", "simpleNameCS", "typeCS",
            "oclExpressionCS", "defExpressionCS", "operationCS1",
            "operationCS2", "prePostOrBodyDeclCSm", "parametersCS",
            "impliesExpCS", "andOrXorExpCS", "andOrXorWithLet",
            "equalityExpCS", "equalityWithLet", "relationalExpCS",
            "relationalWithLet", "ifExpCSPrec", "additiveWithLet",
            "additiveExpCS", "multiplicativeExpCS", "multiplicativeWithLet",
            "unaryExpCS", "unaryWithLet", "dotArrowExpCS", "callExpCS",
            "messageExpCS", "keywordOperationCallExpCS", "argumentsCS",
            "collectionTypeIdentifierCS", "collectionLiteralPartsCS",
            "collectionLiteralPartCS", "variableListCS2", "featureCallExpCS",
            "loopExpCS", "iterContents", "variableCS2", "variableListCS",
            "letExpSubCS", "oclMessageArgumentsCS", "oclMessageArgCS"};
    };

    public final static String name[] = Name.name;

    public final String name(int index) {
        return name[index];
    }

    public final static int ERROR_SYMBOL = 99, SCOPE_UBOUND = 70,
            SCOPE_SIZE = 71, MAX_NAME_LENGTH = 26;

    public final int getErrorSymbol() {
        return ERROR_SYMBOL;
    }

    public final int getScopeUbound() {
        return SCOPE_UBOUND;
    }

    public final int getScopeSize() {
        return SCOPE_SIZE;
    }

    public final int getMaxNameLength() {
        return MAX_NAME_LENGTH;
    }

    public final static int NUM_STATES = 321, NT_OFFSET = 99,
            LA_STATE_OFFSET = 4378, MAX_LA = 2, NUM_RULES = 275,
            NUM_NONTERMINALS = 95, NUM_SYMBOLS = 194, SEGMENT_SIZE = 8192,
            START_STATE = 3891, IDENTIFIER_SYMBOL = 3, EOFT_SYMBOL = 74,
            EOLT_SYMBOL = 74, ACCEPT_ACTION = 4102, ERROR_ACTION = 4103;

    public final static boolean BACKTRACK = false;

    public final int getNumStates() {
        return NUM_STATES;
    }

    public final int getNtOffset() {
        return NT_OFFSET;
    }

    public final int getLaStateOffset() {
        return LA_STATE_OFFSET;
    }

    public final int getMaxLa() {
        return MAX_LA;
    }

    public final int getNumRules() {
        return NUM_RULES;
    }

    public final int getNumNonterminals() {
        return NUM_NONTERMINALS;
    }

    public final int getNumSymbols() {
        return NUM_SYMBOLS;
    }

    public final int getSegmentSize() {
        return SEGMENT_SIZE;
    }

    public final int getStartState() {
        return START_STATE;
    }

    public final int getStartSymbol() {
        return lhs[0];
    }

    public final int getIdentifierSymbol() {
        return IDENTIFIER_SYMBOL;
    }

    public final int getEoftSymbol() {
        return EOFT_SYMBOL;
    }

    public final int getEoltSymbol() {
        return EOLT_SYMBOL;
    }

    public final int getAcceptAction() {
        return ACCEPT_ACTION;
    }

    public final int getErrorAction() {
        return ERROR_ACTION;
    }

    public final boolean isValidForParser() {
        return isValidForParser;
    }

    public final boolean getBacktrack() {
        return BACKTRACK;
    }

    public final int originalState(int state) {
        return -baseCheck[state];
    }

    public final int asi(int state) {
        return asb[originalState(state)];
    }

    public final int nasi(int state) {
        return nasb[originalState(state)];
    }

    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    public final int tAction(int state, int sym) {
        int i = baseAction[state], k = i + sym;
        return termAction[termCheck[k] == sym ? k
            : i];
    }

    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k
            : la_state];
    }
}
