/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.saf.impl;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;

public class SAFManagerUtils {
    public static boolean interfacesMatchReference(WireSource source, WireTarget[] targets) {
        if (source == null || targets == null) {
            return false;
        }
        boolean allMatched = true;
        int maxCount = targets.length;
        if (maxCount == 0) {
            allMatched = false;
        } else {
            int i = 0;
            while (i < maxCount) {
                WireTarget target = targets[i];
                boolean matched = source.matches(target);
                if (!matched) {
                    allMatched = false;
                    break;
                }
                ++i;
            }
        }
        return allMatched;
    }

    public static String getSubstitutionGroupName(SCAObject anSCAObject) {
        return ExtendedMetaData.INSTANCE.getName(SAFManagerUtils.getStructuralFeature(anSCAObject));
    }

    private static EStructuralFeature getStructuralFeature(SCAObject anSCAObject) {
        FeatureAdapter adapter = null;
        adapter = FeatureAdapter.findAdapter((SCAObject)anSCAObject);
        Assert.isTrue((adapter != null || anSCAObject.getEObject().eContainer().eContainingFeature() != null ? 1 : 0) != 0);
        if (adapter != null) {
            return adapter.getFeature();
        }
        EStructuralFeature feature = anSCAObject.getEObject().eContainingFeature();
        if (((EStructuralFeature.Internal)feature).isFeatureMap()) {
            FeatureMap map = (FeatureMap)anSCAObject.getEObject().eContainer().eGet(feature);
            return map.getEStructuralFeature(0);
        }
        return feature;
    }
}

