/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

import java.util.ArrayList;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockLock;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockSync;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockThread;

public abstract class LockObject
implements Cloneable {
    LockObject parent;
    ArrayList children = new ArrayList();
    ArrayList locks = new ArrayList();

    public LockObject(LockObject parent) {
        this.parent = parent;
    }

    public LockThread getParentThread() {
        LockObject tmp = this.parent;
        while (!(tmp instanceof LockThread)) {
            tmp = tmp.getParent();
        }
        return (LockThread)tmp;
    }

    public LockObject getParent() {
        return this.parent;
    }

    public LockObject getChild(int index) {
        return (LockObject)this.children.get(index);
    }

    void add(LockObject obj) {
        this.children.add(obj);
    }

    public void addLock(LockLock lock) {
        this.locks.add(lock);
    }

    public void addSync(LockSync sync) {
        int i = 0;
        while (i < this.children.size()) {
            LockObject obj = this.get(i);
            if (obj instanceof LockSync) {
                LockSync tmp = (LockSync)obj;
                if (sync.from < tmp.from) {
                    this.children.add(i, sync);
                    return;
                }
            }
            ++i;
        }
        this.children.add(sync);
    }

    public LockObject get(int index) {
        return (LockObject)this.children.get(index);
    }

    public int size() {
        return this.children.size();
    }

    public LockLock getLock(String name) {
        int i = 0;
        while (i < this.locks.size()) {
            LockLock tmp = (LockLock)this.locks.get(i);
            if (tmp.getName().equals(name)) {
                return tmp;
            }
            ++i;
        }
        return null;
    }

    public LockObject cloneDeep() throws CloneNotSupportedException {
        LockObject tmp;
        LockObject obj = (LockObject)this.clone();
        int i = 0;
        while (i < obj.children.size()) {
            tmp = (LockObject)obj.children.get(i);
            tmp = tmp.cloneDeep();
            obj.children.set(i, tmp);
            ++i;
        }
        i = 0;
        while (i < obj.locks.size()) {
            tmp = (LockObject)obj.locks.get(i);
            tmp = tmp.cloneDeep();
            obj.locks.set(i, tmp);
            ++i;
        }
        return obj;
    }

    public String toString() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(".Lock") + 5);
        return name;
    }

    public String toString(int depth, boolean show_disabled) {
        LockObject obj;
        StringBuffer sb = new StringBuffer();
        int d = 0;
        while (d < depth) {
            sb.append("  ");
            ++d;
        }
        sb.append(this);
        sb.append("\n");
        int i = 0;
        while (i < this.locks.size()) {
            obj = (LockLock)this.locks.get(i);
            if (show_disabled || ((LockLock)obj).isEnabled()) {
                sb.append(obj.toString(depth + 1, show_disabled));
            }
            ++i;
        }
        i = 0;
        while (i < this.children.size()) {
            LockSync sync;
            obj = (LockObject)this.children.get(i);
            if (show_disabled || !(obj instanceof LockSync) || (sync = (LockSync)obj).isEnabled()) {
                sb.append(obj.toString(depth + 1, show_disabled));
            }
            ++i;
        }
        return sb.toString();
    }

    public ArrayList getDeepLockList() {
        ArrayList tmp = new ArrayList();
        tmp.addAll(this.locks);
        int i = 0;
        while (i < this.children.size()) {
            LockObject obj = (LockObject)this.children.get(i);
            tmp.addAll(obj.getDeepLockList());
            ++i;
        }
        return tmp;
    }

    public ArrayList getDeepSyncList() {
        LockObject obj;
        ArrayList<LockSync> tmp = new ArrayList<LockSync>();
        int i = 0;
        while (i < this.children.size()) {
            LockSync sync;
            obj = this.get(i);
            if (obj instanceof LockSync && (sync = (LockSync)obj).isEnabled()) {
                tmp.add(sync);
            }
            ++i;
        }
        i = 0;
        while (i < this.children.size()) {
            obj = (LockObject)this.children.get(i);
            tmp.addAll(obj.getDeepSyncList());
            ++i;
        }
        return tmp;
    }

    public boolean hasLock(String lockName) {
        int i = 0;
        while (i < this.locks.size()) {
            LockLock lock = (LockLock)this.locks.get(i);
            if (lock.getName().equals(lockName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

