/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.stp.b2j.core.jengine.internal.Version;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.core.PrintHandler;
import org.eclipse.stp.b2j.core.jengine.internal.core.Runner;
import org.eclipse.stp.b2j.core.jengine.internal.core.SubControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.Controller;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.ControllerConnection;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.CriticalThreadGroup;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.NonCriticalThreadGroup;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.TransactionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageReader;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageWriter;
import org.eclipse.stp.b2j.core.jengine.internal.message.TransactionListener;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerOutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ClassPathHacker;
import org.eclipse.stp.b2j.core.jengine.internal.utils.DataTransfer;
import org.eclipse.stp.b2j.core.jengine.internal.utils.GCThread;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ID;
import org.eclipse.stp.b2j.core.jengine.internal.utils.LineBasedPrintStream;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.misc.internal.HexData;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class SubController
extends ControllerConnection
implements SubControllerInterface,
Runnable,
TransactionListener {
    public static final String[] SUBCONTROLLER_SOCKET_IDS = new String[]{"SubController:minor->major transaction", "SubController:minor<-major transaction", "SubController:minor<->major notifications"};
    private static final int CLIENT_CONTROLLER = 0;
    public static final int SUBCONTROLLER_UNRECOGNISED_MESSAGE = -1;
    public static final int SUBCONTROLLER_EMPTY = -2;
    public static final int SUBCONTROLLER_LAUNCH_RUNNER = 10;
    public static final int SUBCONTROLLER_LAUNCH_RUNNER_OK = 11;
    public static final int SUBCONTROLLER_LAUNCH_RUNNER_FAIL = 12;
    public static final int SUBCONTROLLER_SET_PROGRAM = 100;
    public static final int SUBCONTROLLER_SET_PROGRAM_OK = 101;
    public static final int SUBCONTROLLER_SET_PROGRAM_FAIL = 102;
    public static final int SUBCONTROLLER_SIGNAL_RUNNER = 200;
    public static final int SUBCONTROLLER_SIGNAL_RUNNER_OK = 201;
    public static final int SUBCONTROLLER_SIGNAL_RUNNER_FAIL = 202;
    public static final int SUBCONTROLLER_MAKE_VARIABLE = 300;
    public static final int SUBCONTROLLER_MAKE_VARIABLE_OK = 301;
    public static final int SUBCONTROLLER_MAKE_VARIABLE_FAIL = 302;
    public static final int SUBCONTROLLER_NOTIFY_DIRTY = 400;
    public static final int SUBCONTROLLER_NOTIFY_DIRTY_OK = 401;
    public static final int SUBCONTROLLER_NOTIFY_DIRTY_FAIL = 402;
    public static final int SUBCONTROLLER_SYNC_CLOCK = 500;
    public static final int SUBCONTROLLER_SYNC_CLOCK_OK = 501;
    public static final int SUBCONTROLLER_SYNC_CLOCK_FAIL = 502;
    public static final int SUBCONTROLLER_WAKE_RUNNER = 600;
    public static final int SUBCONTROLLER_WAKE_RUNNER_OK = 601;
    public static final int SUBCONTROLLER_WAKE_RUNNER_FAIL = 602;
    public static final int SUBCONTROLLER_RECEIVE_MESSAGE = 700;
    public static final int SUBCONTROLLER_RECEIVE_MESSAGE_OK = 701;
    public static final int SUBCONTROLLER_RECEIVE_MESSAGE_FAIL = 702;
    public static final int SUBCONTROLLER_RUNNER_STACKDUMP = 800;
    public static final int SUBCONTROLLER_SET_CLIENTHOST = 900;
    public static final int SUBCONTROLLER_SET_CLIENTHOST_OK = 901;
    public static final int SUBCONTROLLER_SET_CLIENTHOST_FAIL = 902;
    public static final int SUBCONTROLLER_SET_LOG_LEVEL = 1000;
    public static final int SUBCONTROLLER_SET_LOG_LEVEL_OK = 1001;
    public static final int SUBCONTROLLER_SET_LOG_LEVEL_FAIL = 1002;
    public static final int SUBCONTROLLER_RUNNER_STACKTRACE = 1100;
    public static final int SUBCONTROLLER_CHECK_DEPS_CACHE = 1200;
    public static final int SUBCONTROLLER_CHECK_DEPS_CACHE_OK = 1201;
    public static final int SUBCONTROLLER_CHECK_DEPS_CACHE_FAIL = 1202;
    private static final Object LOCK_SERVER = new Object();
    boolean PRINT_INFO = true;
    boolean PRINT_DEBUG = true;
    long clock = 0L;
    OutputStream stdout = new BufferedOutputStream(new PrintMessageStream());
    Session session;
    RunnerThreadGroup runner_group = new RunnerThreadGroup();
    private int RUNNERS_ID = 1;
    private List activeRunners = Collections.synchronizedList(new LinkedList());
    Program program;
    byte[] programb;
    Class program_class;
    CriticalThreadGroup ctg = new CriticalThreadGroup();
    NonCriticalThreadGroup nctg = new NonCriticalThreadGroup();
    Object notify_LOCK = new Object();
    MessageReader notify_in;
    MessageWriter notify_out;
    SessionAddress actual_address;
    String client_host;
    private static boolean redirected = false;
    PrintHandler ph;

    private static void redirectStdout() {
        redirected = true;
        System.setOut(System.err);
    }

    private static void restoreStdout() {
        SubController.restoreStdout(null);
    }

    private static void restoreStdout(String s) {
        if (redirected) {
            redirected = false;
            PrintStream pout = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128));
            pout.println(s);
            System.setOut(pout);
        }
    }

    public static void main(String[] args) {
        SessionAddress address;
        int id;
        SubController.redirectStdout();
        if (Switches.CONSTANT_GARBAGE_COLLECTION) {
            GCThread.startThread();
        }
        if (args.length < 1) {
            SubController.restoreStdout();
            System.out.println("Too few arguments");
            return;
        }
        try {
            id = Integer.parseInt(args[0]);
        }
        catch (Exception exception) {
            SubController.restoreStdout();
            System.out.println("Invalid id");
            return;
        }
        try {
            BufferedReader bread = new BufferedReader(new InputStreamReader(System.in));
            String req_address = HexData.hexStringToString(bread.readLine().trim());
            address = SessionAddress.fromString(req_address);
        }
        catch (Exception exception) {
            SubController.restoreStdout();
            System.out.println("Invalid session address");
            return;
        }
        try {
            new SubController(address, id);
        }
        catch (Exception e) {
            SubController.restoreStdout();
            e.printStackTrace();
        }
    }

    public SubController(SessionAddress session_address, int id) throws Exception {
        super(id);
        this.id = id;
        try {
            this.session = SessionFactory.newSession(session_address, false);
            this.session.beginNonBlocking();
            this.session.waitUntilSessionTransportBound();
            this.actual_address = this.session.getActualAddress();
            SubController.restoreStdout(HexData.stringToHexString(SessionAddress.toString(this.session.getActualAddress())));
            System.out.flush();
            Thread th = new Thread(this);
            th.setName("JEngine SubController [Controller Server Init] Thread (ID: " + id + ") (" + this.actual_address + ")");
            th.start();
        }
        catch (IOException iOException) {}
        System.gc();
    }

    public SessionAddress getAddress() {
        return this.actual_address;
    }

    public long getClock() {
        return System.currentTimeMillis() - this.clock;
    }

    public void run() {
        Thread.currentThread();
        try {
            this.session.waitUntilSessionTransportReady();
            Logger.direct("new SubController (version " + Version.getVersionAsString() + ") on " + this.session.getActualAddress());
            short s_server = 0;
            short s_client = 1;
            short s_notify = 2;
            MultiplexerInputStream mxin = new MultiplexerInputStream(this.session.getInputStream((short)0));
            MultiplexerOutputStream mxout = new MultiplexerOutputStream(this.session.getOutputStream((short)0));
            this.ts = TransactionFactory.getTransactionServer(mxin.getInputStream(s_server), mxout.getOutputStream(s_server), this, this.ctg, "JEngine SubController [Controller Client Reader] Thread (ID: " + this.id + ") (" + this.actual_address + ")");
            this.tc = TransactionFactory.getTransactionClient(mxin.getInputStream(s_client), mxout.getOutputStream(s_client), this.ctg, "JEngine SubController [Controller Server] Thread (ID: " + this.id + ") (" + this.actual_address + ")");
            this.notify_in = new MessageReader(mxin.getInputStream(s_notify), this.ctg, "JEngine SubController [Controller Notify Reader] Thread (ID: " + this.id + ") (" + this.actual_address + ")");
            this.notify_out = new MessageWriter(mxout.getOutputStream(s_notify));
        }
        catch (Throwable throwable) {
            Logger.error("error while setting up connection");
        }
    }

    private void setProgram(byte[] programb, Message dependencies) throws Exception {
        this.programb = programb;
        this.program = Program.readProgram(programb);
        Controller.storeNewJarsToCache(dependencies);
        if (this.program.getPrintStdouterr()) {
            Logger.direct("Redirecting stdout to engine messaging");
            System.setOut(new PrintStream(new LineBasedPrintStream(){

                public void doSomethingWith(String s) {
                    try {
                        SubController.this.print(s);
                    }
                    catch (Exception exception) {
                        Logger.warning(s);
                    }
                }
            }));
            System.setErr(new PrintStream(new LineBasedPrintStream(){

                public void doSomethingWith(String s) {
                    try {
                        SubController.this.print(s);
                    }
                    catch (Exception exception) {
                        Logger.warning(s);
                    }
                }
            }));
        }
        this.PRINT_INFO = this.program.getPrintInfo();
        this.PRINT_DEBUG = this.program.getPrintDebug();
        URL[] dep_urls = new URL[dependencies.length()];
        int i = 0;
        while (i < dep_urls.length) {
            JARDependency orig;
            if (dependencies.getType(i) == 4) {
                orig = JARDependency.fromMessage((Message)dependencies.get(i));
            } else {
                String cachekey = (String)dependencies.get(i);
                String path = "depscache/" + cachekey;
                FileInputStream fin = new FileInputStream(path);
                byte[] dat = StreamUtils.readAll(fin);
                fin.close();
                orig = new JARDependency(dat, path);
            }
            Logger.direct("dependency " + i + " of " + dep_urls.length);
            Logger.direct("processing dependency " + orig.getFileName() + " (" + orig.getJarData().length + " bytes)");
            JARDependency local = JARDependency.writeTemporaryDependency(orig);
            Logger.direct("processed dependency " + local.getFileName() + ", stored to " + local.getFilePath());
            dep_urls[i] = new File(local.getFilePath()).toURL();
            try {
                ClassPathHacker.addFile(new File(local.getFilePath()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.program_class = this.program.getProgramClass(dep_urls, SubController.class.getClassLoader());
    }

    private Object[] launchRunner(int count, String method, Message args) throws Exception {
        Message launched = new Message();
        ArrayList<Runner> rthreads = new ArrayList<Runner>();
        int i = 0;
        while (i < count) {
            long rid = ID.CREATE_ID(this.id, this.RUNNERS_ID++);
            ID.ID_HEX(rid);
            Object program_object = this.program_class.newInstance();
            Field runner_id = this.program_class.getDeclaredField("runner_id");
            runner_id.setAccessible(true);
            runner_id.setLong(program_object, rid);
            Field runner_args = this.program_class.getDeclaredField("runner_args");
            runner_args.setAccessible(true);
            runner_args.set(program_object, args);
            Runner r = new Runner(this.runner_group, "JEngine Runner Thread (ID: " + ID.ID_HEX(rid) + ")", this, rid, this.program_class, program_object, method);
            this.activeRunners.add(r);
            r.start();
            launched.append(rid);
            rthreads.add(r);
            ++i;
        }
        return new Object[]{launched, rthreads};
    }

    public ArrayList launchRunnerLocal(int count, String method, ArrayList args) throws Exception {
        Message margs = new Message();
        int i = 0;
        while (i < args.size()) {
            margs.append((String)args.get(i));
            ++i;
        }
        return this.launchRunnerLocal(count, method, margs);
    }

    public ArrayList launchRunnerLocal(int count, String method, Message args) throws Exception {
        return (ArrayList)this.launchRunner(count, method, args)[1];
    }

    public String getHost() throws Exception {
        return this.actual_address.getListenerHost();
    }

    public String getClientHost() throws Exception {
        return this.client_host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Message m) throws Exception {
        Message trace = new Message(1200);
        trace.append(m);
        if (Switches.MESSAGES_WITH_CALLSTACK) {
            trace.appendToCallStack(new Throwable("Message Callstack - Trace"));
        }
        Object object = this.notify_LOCK;
        synchronized (object) {
            this.notify_out.write(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String s) throws Exception {
        if (!this.PRINT_INFO) {
            return;
        }
        if (this.ph != null) {
            this.ph.print(s);
        } else {
            Message m = new Message(1400);
            m.append(s);
            if (Switches.MESSAGES_WITH_CALLSTACK) {
                m.appendToCallStack(new Throwable("Message Callstack - Print"));
            }
            Object object = this.notify_LOCK;
            synchronized (object) {
                this.notify_out.write(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String s) throws Exception {
        if (!this.PRINT_DEBUG) {
            return;
        }
        if (this.ph != null) {
            this.ph.debug(s);
        } else {
            Message m = new Message(3200);
            m.append(s);
            if (Switches.MESSAGES_WITH_CALLSTACK) {
                m.appendToCallStack(new Throwable("Message Callstack - Debug"));
            }
            Object object = this.notify_LOCK;
            synchronized (object) {
                this.notify_out.write(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Object[] al) throws Exception {
        Message m = new Message(1200);
        m.append(DataTransfer.serialise(al));
        if (Switches.MESSAGES_WITH_CALLSTACK) {
            m.appendToCallStack(new Throwable("Message Callstack - Trace Objects"));
        }
        Object object = this.notify_LOCK;
        synchronized (object) {
            this.notify_out.write(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRunnerDeath(long id, Runner runner) throws Exception {
        this.activeRunners.remove(runner);
        Message m = new Message(2500);
        m.append(id);
        if (Switches.MESSAGES_WITH_CALLSTACK) {
            m.appendToCallStack(new Throwable("Message Callstack - Notify Runner Death"));
        }
        Object object = this.notify_LOCK;
        synchronized (object) {
            this.notify_out.write(m);
        }
    }

    public Message doTransaction(Message m) {
        Message r;
        int type = m.getType();
        if (type == -2) {
            r = m;
        } else if (type == 500) {
            this.clock = System.currentTimeMillis();
            Long offset = (Long)m.get(0);
            this.clock -= offset.longValue();
            r = new Message(501);
        } else if (type == 100) {
            Logger.info("SUBCONTROLLER: Set program");
            try {
                this.setProgram((byte[])m.get(0), (Message)m.get(1));
                r = new Message(101);
            }
            catch (Exception e) {
                r = new Message(102);
                r.append(Logger.getStackTrace(e));
            }
        } else if (type == 1200) {
            Logger.info("SUBCONTROLLER: Check JAR Dependencies Cache");
            r = Controller.checkDependenciesCache(m);
            r.setType(1201);
        } else if (type == 10) {
            Logger.info("SUBCONTROLLER: Launch Runner");
            Integer count = (Integer)m.get(0);
            String method = (String)m.get(1);
            Message args = new Message();
            if (m.length() > 2) {
                args.appendAll((Message)m.get(2));
            }
            try {
                Message launched = (Message)this.launchRunner((int)count, method, args)[0];
                r = new Message(11);
                r.append(launched);
            }
            catch (Exception e) {
                r = new Message(102);
                r.append(Logger.getStackTrace(e));
            }
        } else if (type == 1100) {
            Logger.direct("SUBCONTROLLER STACK TRACE");
            Integer trace_msg_id = (Integer)m.get(0);
            try {
                int i = 0;
                while (i < this.activeRunners.size()) {
                    Runner runner = (Runner)this.activeRunners.get(i);
                    Message stackmsg = runner.getStackContents();
                    stackmsg.setType(trace_msg_id);
                    this.trace(stackmsg);
                    ++i;
                }
            }
            catch (Throwable t) {
                Logger.error("Error generating stacktrace", t);
            }
            r = new Message(1100);
        } else if (type == 800) {
            Logger.direct("SUBCONTROLLER STACK DUMP");
            try {
                int i = 0;
                while (i < this.activeRunners.size()) {
                    StringBuffer sb = new StringBuffer("SubController " + this.getHost() + " - Runner Stack Dump:\n");
                    Runner runner = (Runner)this.activeRunners.get(i);
                    String tmp = runner.getStack();
                    Logger.direct(tmp);
                    sb.append(tmp);
                    this.print(sb.toString());
                    ++i;
                }
            }
            catch (Throwable t) {
                Logger.error("Error tracing stackdump", t);
            }
            r = new Message(800);
        } else if (type == 900) {
            Logger.direct("SUBCONTROLLER SET CLIENT HOST");
            try {
                this.client_host = (String)m.get(0);
                r = new Message(901);
            }
            catch (Throwable t) {
                r = new Message(902);
                r.append(Logger.getStackTrace(t));
            }
        } else {
            r = super.doTransaction(m);
        }
        return r;
    }

    public void setPrintHandler(PrintHandler ph) throws Exception {
        this.ph = ph;
    }

    class PrintMessageStream
    extends OutputStream {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();

        PrintMessageStream() {
        }

        public void write(int i) {
            this.bout.write((byte)(i & 0xFF));
        }

        public void write(byte[] b) {
            int i = 0;
            while (i < b.length) {
                this.bout.write(b[i]);
                if (b[i] == 10) {
                    this.flush();
                }
                ++i;
            }
        }

        public void write(byte[] b, int off, int len) {
            int i = off;
            while (i < len) {
                this.bout.write(b[i]);
                if (b[i] == 10) {
                    this.flush();
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            ByteArrayOutputStream byteArrayOutputStream = this.bout;
            synchronized (byteArrayOutputStream) {
                try {
                    SubController.this.print(new String(this.bout.toByteArray()));
                }
                catch (Exception exception) {}
                this.bout.reset();
            }
        }
    }

    class RunnerThreadGroup
    extends ThreadGroup {
        public RunnerThreadGroup() {
            super("Runner Thread Group");
        }

        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace();
        }
    }
}

