/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.WorkbenchResourceHelper;

public class DeletedResourceAdapter extends AdapterImpl {
   public static String DELETED_RESOURCE_TYPE = DeletedResourceAdapter.class
                                                    .toString();

   public static DeletedResourceAdapter findAdapter(Resource aResource) {
      return (DeletedResourceAdapter) EcoreUtil.getAdapter(aResource
            .eAdapters(), DELETED_RESOURCE_TYPE);
   }

   public DeletedResourceAdapter findSpecificAdapter(Resource aResource) {
      return (DeletedResourceAdapter) EcoreUtil.getAdapter(aResource
            .eAdapters(), this);
   }

   public boolean isDeleted(Resource aResource) {
      return findSpecificAdapter(aResource) != null;
   }

   public void addAdapterIfNecessary(Resource aResource) {
      synchronized (this) {
         if (findSpecificAdapter(aResource) == null)
            aResource.eAdapters().add(this);
      }
   }

   public boolean isAdapterForType(Object type) {
      return (type == DELETED_RESOURCE_TYPE || type == this);
   }

   public void setTarget(Notifier aTarget) {
      Assert.isTrue(aTarget instanceof Resource);
   }

   public boolean undeleteResource(Resource aResource, IProgressMonitor aMonitor)
         throws CoreException {
      Assert.isNotNull(aResource);
      /* Assert.isTrue(findSpecificAdapter(aResource) != null); */
      IFile deletedFile = WorkbenchResourceHelper.getFile(aResource);
      IFileState[] states = deletedFile.getHistory(aMonitor);
      for (int i = 0; i < states.length; i++) {
         if (states[i].exists()) {
            deletedFile.create(states[i].getContents(), true, aMonitor);
            return true;
         }
      }
      return false;
   }
}
