/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.stp.soas.deploy.models.deployfile;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Deploy Package</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getTargetConfiguration <em>Target Configuration</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getRoot <em>Root</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getPackageFile <em>Package File</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage#getDeployPackage()
 * @model
 * @generated
 */
public interface DeployPackage extends EObject {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "(c) 2004 Sybase, Inc.";

	/**
	 * Returns the value of the '<em><b>Target Configuration</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getSourcePackage <em>Source Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target Configuration</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Target Configuration</em>' containment reference list.
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage#getDeployPackage_TargetConfiguration()
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration#getSourcePackage
	 * @model type="org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration" opposite="sourcePackage" containment="true"
	 * @generated
	 */
	EList getTargetConfiguration();

	/**
	 * Returns the value of the '<em><b>Root</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.stp.soas.deploy.models.deployfile.Root#getPackage <em>Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Root</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Root</em>' container reference.
	 * @see #setRoot(Root)
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage#getDeployPackage_Root()
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.Root#getPackage
	 * @model opposite="package" unsettable="true" required="true"
	 * @generated
	 */
	Root getRoot();

	/**
	 * Sets the value of the '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getRoot <em>Root</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Root</em>' container reference.
	 * @see #getRoot()
	 * @generated
	 */
	void setRoot(Root value);

	/**
	 * Returns the value of the '<em><b>Package File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Package File</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Package File</em>' attribute.
	 * @see #setPackageFile(String)
	 * @see org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage#getDeployPackage_PackageFile()
	 * @model id="true" required="true"
	 * @generated
	 */
	String getPackageFile();

	/**
	 * Sets the value of the '{@link org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage#getPackageFile <em>Package File</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Package File</em>' attribute.
	 * @see #getPackageFile()
	 * @generated
	 */
	void setPackageFile(String value);

} // DeployPackage
