/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif;

import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationSet;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.utils.MultiString;

/**
 * 
 * @author amiguel
 *
 * The WSIF Java binding
 */
public class WSIFJavaBinding {
	
HashMap all_ports = new HashMap();
	
	public JavaPortGroup getPortGroupForEndpointReference(WSEndpointReference epr, BPELCorrelationSet cset) throws Exception {
		
//TODO do we need to index port groups by more than java class? should we be using classLoader and classPath too?

		String[] key = new String[2];

		key[0] = epr.getAddress();
		if (cset == null) {
			key[1] = "";
		} else {
			key[1] = cset.toString();
		}
			
		MultiString mstring = new MultiString(key);
		
		//get all ports for this endpoint reference address (java class)
		JavaPortGroup pg = (JavaPortGroup)all_ports.get(mstring);
		
		if (pg == null) {
			//no port group for this address, create a new one
			pg = new JavaPortGroup(epr);
			all_ports.put(mstring,pg);
		}
		
		return pg;
	}
	
	public class JavaPortGroup {
		WSEndpointReference epr;
		
		WSIFJavaPort port;
		
		public JavaPortGroup(WSEndpointReference epr) throws Exception {
			this.epr = epr;
			port = new WSIFJavaPort(epr.getAddress());
		}
		
		public WSIFJavaPort getPort() throws Exception {
			return port;
		}
	}
	

}