/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.util.LinkedList;

/**
 * @author amiguel
 * 
 * Unique ID pool
 * creates a pool of integers from 0 - N
 * provides unique IDs from the pool
 * if no more than X clients ever hold an ID at any time then the pool will never be more than
 * X in size and the range of the IDs will be 0 - X
 */
public class UIDPool {
	Object uid_lock = new Object();
	LinkedList uid_queue = new LinkedList();
	int uid_next = 0;

	public UIDPool() {
		this(0);
	}

	public UIDPool(int siz) {
		for (int i = 0; i < siz; i++) {
			//add a uid to the pool
			uid_queue.add(new Integer(uid_next++));
		}
	}

	public int getUID() {
		Integer uid;
		synchronized(uid_lock) {
			if (uid_queue.size() == 0) {
				//no unique ids left - add another to the pool
				uid_queue.add(new Integer(uid_next++));
			}
			uid = (Integer)uid_queue.removeFirst();
		}
		return uid.intValue();
	}
	public void releaseUID(int uid) {
		synchronized(uid_lock) {
			uid_queue.add(new Integer(uid));
		}
	}
}