/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.text.DecimalFormat;


/**
 * 
 * @author amiguel
 *
 * A runtime class used to implement XPATH expression
 */
public class XPU {

//
// UTILITY FUNCTIONS
//
/*	private static String toString(XNodeSet obj) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < obj.size(); i++) {
			sb.append(obj.get(i).toString());
		}
		return sb.toString();
	}
*/
//
// Node Set Greater Than functions
//
	private static boolean gt(XNodeSet a1, XNodeSet a2) {
		for (int i = 0; i < a2.size(); i++) {
			String s2 = a2.get(i).toString();
			Number n2 = toNumber(s2);
			if (gt(a1,n2)) return true;
		}
		return false;
	}
	private static boolean gt(XNodeSet a1, Number n2) {
		for (int i = 0; i < a1.size(); i++) {
			String s1 = a1.get(i).toString();
			Number n1 = toNumber(s1);
			if (n1.doubleValue() > n2.doubleValue()) return true;
		}
		return false;
	}
	private static boolean ge(XNodeSet a1, XNodeSet a2) {
		for (int i = 0; i < a2.size(); i++) {
			String s2 = a2.get(i).toString();
			Number n2 = toNumber(s2);
			if (ge(a1,n2)) return true;
		}
		return false;
	}
	private static boolean ge(XNodeSet a1, Number n2) {
		for (int i = 0; i < a1.size(); i++) {
			String s1 = a1.get(i).toString();
			Number n1 = toNumber(s1);
			if (n1.doubleValue() >= n2.doubleValue()) return true;
		}
		return false;
	}

	
//
// Node Set Greater Equals functions
//
	private static boolean equals(XNodeSet a1, XNodeSet a2) {
		for (int i = 0; i < a2.size(); i++) {
			String s2 = a1.get(i).toString();
			if (equals(a1,s2)) return true;
		}
		return false;
	}
	
	private static boolean equals(XNodeSet a1, Number n2) {
		for (int i = 0; i < a1.size(); i++) {
			String s1 = a1.get(i).toString();
			Number n1 = toNumber(s1);
			if (n1.equals(n2)) return true;
		}
		return false;
	}
	
	private static boolean equals(XNodeSet a1, String s2) {
		for (int i = 0; i < a1.size(); i++) {
			String s1 = a1.get(i).toString();
			if (s1.equals(s2)) return true;
		}
		return false;
	}

//
// EXPOSED FUNCTIONS
//
	public static Boolean and(Object o1, Object o2) {
		boolean b = toBoolean(o1).booleanValue() && toBoolean(o2).booleanValue();
		return new Boolean(b);
	}

	public static Boolean or(Object o1, Object o2) {
		boolean b = toBoolean(o1).booleanValue() || toBoolean(o2).booleanValue();
		return new Boolean(b);
	}

	public static boolean gt(Object o1, Object o2) {
		if (o1 instanceof XNodeSet) {
			if (o2 instanceof XNodeSet) {
				//node set > node set
				return gt((XNodeSet)o1,(XNodeSet)o2);
			} else {
				//node set > number
				return gt((XNodeSet)o1,toNumber(o2));
			}
		} else if (o2 instanceof XNodeSet) {
			//number > node set
			return !ge((XNodeSet)o2,toNumber(o1));
		} else {
			Number n1 = toNumber(o1);
			Number n2 = toNumber(o2);
			return n1.doubleValue() > n2.doubleValue();
		}
	}

	public static boolean ge(Object o1, Object o2) {
		if (o1 instanceof XNodeSet) {
			if (o2 instanceof XNodeSet) {
				//node set >= node set
				return ge((XNodeSet)o1,(XNodeSet)o2);
			} else {
				//node set >= number
				return ge((XNodeSet)o1,toNumber(o2));
			}
		} else if (o2 instanceof XNodeSet) {
			//number >= node set
			return !gt((XNodeSet)o2,toNumber(o1));
		} else {
			Number n1 = toNumber(o1);
			Number n2 = toNumber(o2);
			return n1.doubleValue() >= n2.doubleValue();
		}
	}

	public static boolean lt(Object o1, Object o2) {
		return gt(o2,o1);
	}

	public static boolean le(Object o1, Object o2) {
		return ge(o2,o1);
	}

	public static boolean ne(Object o1, Object o2) {
		return !eq(o1,o2);
	}
	
	public static boolean eq(Object o1, Object o2) {
		if (o1 instanceof XNodeSet) {
			if (o2 instanceof XNodeSet) {
				//node set == node set
				return equals((XNodeSet)o1,(XNodeSet)o2);
			} else if (o2 instanceof Number) {
				//node set == number
				return equals((XNodeSet)o1,(Number)o2);
			} else if (o2 instanceof String) {
				//node set == string
				return equals((XNodeSet)o1,(String)o2);
//			} else if (o2 instanceof Boolean) {
			} else {
				//node set == boolean
				return toBoolean(o1).equals(o2);
			}
		} else if (o2 instanceof XNodeSet) {
			if (o1 instanceof Number) {
				//number == node set
				return equals((XNodeSet)o2,(Number)o1);
			} else if (o1 instanceof String) {
				//node set == string
				return equals((XNodeSet)o2,(String)o1);
//			} else if (o1 instanceof Boolean) {
			} else {
				//node set == boolean
				return o1.equals(toBoolean(o2));
			}
		} else if (o1 instanceof Boolean || o2 instanceof Boolean) {
			Boolean b1 = toBoolean(o1);
			Boolean b2 = toBoolean(o2);
			return b1.equals(b2);
		} else if (o1 instanceof Number || o2 instanceof Number) {
			Number n1 = toNumber(o1);
			Number n2 = toNumber(o2);
			return n1.equals(n2);
		} else {
			String s1 = toString(o1);
			String s2 = toString(o2);
			return s1.equals(s2);
		}
	}
	
	public static Double negate(Object o1) {
		return negate(toNumber(o1));
	}

	public static Double negate(Double o1) {
		return new Double(-o1.doubleValue());
	}
	
	public static Double add(Object o1, Object o2) {
		Double n1 = toNumber(o1);
		Double n2 = toNumber(o2);
		return new Double(n1.doubleValue() + n2.doubleValue());
	}

	public static Double subtract(Object o1, Object o2) {
		Double n1 = toNumber(o1);
		Double n2 = toNumber(o2);
		return new Double(n1.doubleValue() - n2.doubleValue());
	}

	public static Double multiply(Object o1, Object o2) {
		Double n1 = toNumber(o1);
		Double n2 = toNumber(o2);
		return new Double(n1.doubleValue() * n2.doubleValue());
	}

	public static Double div(Object o1, Object o2) {
		Double n1 = toNumber(o1);
		Double n2 = toNumber(o2);
		return new Double(n1.doubleValue() / n2.doubleValue());
	}
	
	public static Double mod(Object o1, Object o2) {
		Double n1 = toNumber(o1);
		Double n2 = toNumber(o2);
		return new Double(n1.doubleValue() % n2.doubleValue());
	}

	public static Double toNumber(Object o) {
		if (o instanceof Number) {
//			return new Double( ((Number)o).doubleValue() );
			return (Double)o;
		} else if (o instanceof String) {
			try {
				return new Double( (String)o );
			} catch (NumberFormatException e) {
				return new Double( Double.NaN );
			}
		} else if (o instanceof Boolean) {
			if ( ((Boolean)o).booleanValue() ) {
				//boolean true = 1
				return new Double( 1 );
			} else {
				//boolean false = 0
				return new Double( 0 );
			}
		} else if (o instanceof XNodeSet) {
			return ((XNodeSet)o).toNumber();
		} else if (o instanceof XPathAccessible) {
			Double d = ((XPathAccessible)o).toXpathNumber();
			if (d != null) {
				return d;
			}
		}

		
		//? node set (XNodeSet)
		
		String s = toString(o);
		try {
			return new Double( s );
		} catch (NumberFormatException e) {
			return new Double( Double.NaN );
		}
	}

	public static void toString(Object o, StringBuffer sb) {
		if (o != null) {
			if (o instanceof XPathAccessible) {
//Logger.direct("XPATH STRING VALUE of "+o+" == "+((XPathAccessible)o).toXpathStringValue());
				((XPathAccessible)o).appendXpathStringValue(sb);
			} else {
			    if (o instanceof Number) {
			        DecimalFormat df = new DecimalFormat("############################0.##############################");
			        sb.append(df.format(((Number)o).doubleValue()));
			    } else {
			        sb.append(o.toString());
			    }
			}
		}
	}

	public static String toString(Object o) {
		if (o == null) return "";
		if (o instanceof XPathAccessible) {
//Logger.direct("XPATH STRING VALUE of "+o+" == "+((XPathAccessible)o).toXpathStringValue());
			
			return ((XPathAccessible)o).toXpathStringValue();
		}
	    if (o instanceof Number) {
	        DecimalFormat df = new DecimalFormat("###############################0.##################################");
	        return df.format(((Number)o).doubleValue());
	    }
		return o.toString();
	}
	
	public static Boolean toBoolean(Object o) {
		if (o instanceof Boolean) {
			return (Boolean)o;
		} else if (o instanceof XNodeSet) {
			return new Boolean( ((XNodeSet)o).size() > 0 );
		} else if (o instanceof Number) {
			return new Boolean( ((Number)o).doubleValue() != 0 );
//		} else if (o instanceof String) {
		} else {
			return new Boolean( ((String)o).length() > 0 );
		}
	}
	
	public static XNodeSet getNodeSet(XNodeSet orig) {
		XNodeSet set = new XNodeSet();
		set.addAll(orig);
		return set;
	}
	/*
	public static XNodeSet getSingleNodeSet(Object obj) {
		XNodeSet set = new XNodeSet();
		set.add(new Node(obj);
		return set;
	}

	public static ArrayList getSingleNodeSet(Object[] obj) {
		ArrayList set = new ArrayList();
		for (int i = 0; i < obj.length; i++) {
			set.add(obj[i]);
		}
		return set;
	}
	*/

	public static XNodeSet getSingleNodeSet(String name, Object val, Object[] container, int containerIndex, XNode parent) {
		XNodeSet set = new XNodeSet();
		set.add(new XNode(name,val,container,containerIndex,parent));
		return set;
	}
	
	public static XNodeSet getSingleNodeSet(String name, Object val, Object[] container, int containerIndex) {
		return getSingleNodeSet(name,val,container,containerIndex,null);
	}
	
	public static XNodeSet getSingleNodeSet(XNode node) {
		XNodeSet set = new XNodeSet();
		set.add(node);
		return set;
	}
	
	public static XNodeSet nameTest(XNodeSet set, String name) {

		if (name.equals("*")) return set;
		
		XNodeSet ret = new XNodeSet();
		
		if (name.endsWith("*")) {
			name = name.substring(0,name.length()-1);
			for (int i = 0; i < set.size(); i++) {
				XNode node = set.get(i);
				if (node.name.startsWith(name)) {
					ret.add(node);
				}
			}
		} else {
			for (int i = 0; i < set.size(); i++) {
				XNode node = set.get(i);
//System.out.println("XPU,nameTest:["+name+"]==["+node.name+"]");			
				if (node.name.equals(name)) {
					ret.add(node);
				}
			}
		}
		return ret;
	}
//
// FUNCTIONS
//
	public static Double toNumber(XNodeSet set, Object o, int pos, XNodeSet context) {
		return toNumber(o);
	}
	public static String toString(XNodeSet set, Object o, int pos, XNodeSet context) {
		return toString(o);
	}
	public static Boolean toBoolean(XNodeSet set, Object o, int pos, XNodeSet context) {
		return toBoolean(o);
	}

	public static Boolean stringContains(XNodeSet set, Object o1, Object o2, int pos, XNodeSet context) {
		String s1 = (String)o1;
		String s2 = (String)o2;
		return new Boolean(s1.indexOf(s2) != -1);
	}
	public static Boolean stringStartsWith(XNodeSet set, Object o1, Object o2, int pos, XNodeSet context) {
		String s1 = (String)o1;
		String s2 = (String)o2;
		return new Boolean(s1.startsWith(s2));
	}
	public static Double stringLength(XNodeSet set, Object o, int pos, XNodeSet context) {
		String s1 = (String)o;
		return new Double(s1.length());
	}
	
	public static Boolean booleanTrue(XNodeSet set, int pos, XNodeSet context) {
		return Boolean.TRUE;
	}
	public static Boolean booleanFalse(XNodeSet set, int pos, XNodeSet context) {
		return Boolean.FALSE;
	}
	public static Boolean booleanNot(XNodeSet set, Object o, int pos, XNodeSet context) {
		Boolean b = (Boolean)o;
		return new Boolean(!b.booleanValue());
	}
	
	public static Double numberFloor(XNodeSet set, Object o, int pos, XNodeSet context) {
		Number num = (Number)o;
		return new Double( Math.floor(num.doubleValue()) );
	}
	public static Double numberCeiling(XNodeSet set, Object o, int pos, XNodeSet context) {
		Number num = (Number)o;
		return new Double( Math.ceil(num.doubleValue()) );
	}
	public static Double numberRound(XNodeSet set, Object o, int pos, XNodeSet context) {
		Number num = (Number)o;
		return new Double( Math.floor(0.5d + num.doubleValue()) );
	}
	public static Double numberSum(XNodeSet set, int pos, XNodeSet context) {
		double d = 0;
		for (int i = 0; i < set.size(); i++) {
			XNode node = set.get(i);
			d += toNumber(node).doubleValue();
		}
		return new Double(d);
	}
	
//
// AXES
//
	public static XNodeSet child(XNodeSet set, int pos, XNodeSet context) {
		XNodeSet ret = new XNodeSet();

//		System.out.println(set.size()+" CHILDREN");		
		for (int i = 0; i < set.size(); i++) {
			XNode node = set.get(i);

//			System.out.println("---"+node.getValue());		
			
			XNodeSet children = node.getValue().getFieldSet(node);

//			System.out.println("   ("+children.size()+", "+children+")");		
			ret.addAll(children);
		}
		
		return ret;
	}
	
	public static XNodeSet descendant(XNodeSet set, int pos, XNodeSet context) {
		XNodeSet ret = new XNodeSet();

		for (int i = 0; i < set.size(); i++) {
			XNode node = set.get(i);
			// add this node
			ret.add(node);
			
			// add all its descendants
			XNodeSet tmp = node.getValue().getFieldSet(node);
			if (tmp.size() > 0) {
				ret.addAll(descendant(tmp,pos,context));
			}
		}
		
		return ret;
	}

	public static XNodeSet parent(XNodeSet set, int pos, XNodeSet context) {
		XNodeSet ret = new XNodeSet();

		for (int i = 0; i < set.size(); i++) {
			XNode node = set.get(i).getParent();
			if (node != null) ret.add(node);
		}
		
		return ret;
	}

	public static XNodeSet ancestor(XNodeSet set, int pos, XNodeSet context) {
		XNodeSet ret = new XNodeSet();

		for (int i = 0; i < set.size(); i++) {
			XNode node = set.get(i).getParent();
			if (node != null) {
				ret.add(node);
			}
		}
		
		ret.addAll(ancestor(ret,pos,context));
		
		return ret;
	}	
}