/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import java.util.Arrays;
import java.util.HashMap;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedHashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.debug.DebugConstants;

/**
 * 
 * @author amiguel
 *
 * BPEL engine debug target
 */
public class ControllerDebugTarget extends ControllerDebugElement implements IDebugTarget {

	public ControllerInterface engine;
	public String engine_name;
	public ControllerDebugProcess process;
	public ControllerStackTracker stack_tracker;
	
	public ILaunch launch;
	HashMap threadIds = new HashMap();
	public IThread[] threads = new IThread[0];
	
	public ControllerDebugTarget(ILaunch launch, ControllerInterface controller, String engine_name) {
		super(null);
		this.launch = launch;
		this.engine = controller;
		this.engine_name = engine_name;
		
		stack_tracker = new ControllerStackTracker(controller);
		
		process = new ControllerDebugProcess(launch,controller,engine_name);
		
		try {
			//ensure these are already created so we dont get sync issues where we both create at the same time
			getThreadMap();
			getSuspendVariable();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		DebugUtils.fireCreationEvent(this);
	}
	
	public ILaunch getLaunch() {
		return launch;
	}
	
	private SharedHashMap getThreadMap() throws Exception {
		SharedHashMap map = engine.newHashMap(DebugConstants.BPEL_THREADS_MAP);
		return map;
	}
	private SharedVariable getSuspendVariable() throws Exception {
		SharedVariable var = engine.newVariable(DebugConstants.BPEL_BREAKPOINT_VAR,SharedVariable.INTEGER,true);
		return var;
	}

	//
	// DebugTarget implementation
	//
	public IProcess getProcess() {
		System.err.println("getProcess()");
		return process;
	}
	
	public IDebugTarget getDebugTarget() {
		return this;
	}

	public String getName() throws DebugException {
		return engine_name;
	}

	public boolean canTerminate() {
		return process.canTerminate();
	}

	public boolean isTerminated() {
		return process.isTerminated();
	}

	public void terminate() throws DebugException {
		process.terminate();
	}
	
	public IThread[] getThreads() throws DebugException {
		if (isTerminated()) return new IThread[0];
		System.err.println("getThreads()");
//		if (threads == null) {
			try {
				System.err.println("GETTING THREADS FROM ENGINE");				
			//	HashMap currentThreadIds = new HashMap();
				
				SharedHashMap map = getThreadMap();
				String[] keys = map.getKeys();

				Arrays.sort(keys);
				
				IThread[] tmp = new IThread[keys.length];
				for (int i = 0; i < tmp.length; i++) {
//					System.err.println("THREAD"+keys[i]);				
					tmp[i] = new RunnerDebugThread(this,engine,stack_tracker,keys[i]);
/*					
					IThread ithread = (IThread)threadIds.remove(keys[i]);
					if (ithread == null) {
						//thread create
//						DebugUtils.fireCreationEvent(tmp[i]);
						System.err.println("THREAD CREATE - "+tmp[i].getName());				
					}*/
				}
				/*
				//any left in the map aren't in the shared hashmap any more (so they have terminated)
				ArrayList deadthreads = new ArrayList(threadIds.keySet());
				for (int i = 0; i < deadthreads.size(); i++) {
					IThread deadthread = (IThread)threadIds.get(deadthreads.get(i));
//					DebugUtils.fireTerminateEvent(deadthread);
					System.err.println("THREAD TERMINATE - "+deadthread.getName());				
				}*/
				
//				threadIds.clear();
				
//				for (int i = 0; i < tmp.length; i++) {
//					threadIds.put(tmp[i].getName(),tmp[i]);
//				}
				
				threads = tmp;
			} catch (Exception e) {
e.printStackTrace();				
//				threads = new IThread[0];
			}
//		}
		return threads;
	}

	public boolean hasThreads() throws DebugException {
		System.err.println("hasThreads() - true");
		return true;
	}

	public boolean supportsBreakpoint(IBreakpoint breakpoint) {
		System.err.println("supportsBreakpoint() - false");
		return false;
	}

	public boolean canResume() {
		System.err.println("canResume()");
		return !isTerminated() && isSuspended();
	}

	public boolean canSuspend() {
		return !isTerminated();
//		System.err.println("canSuspend()");
//		return !isTerminated() && !isSuspended();
	}

	public boolean isSuspended() {
		if (isTerminated()) return false;
		System.err.println("isSuspended()");
		try {
			SharedVariable var = getSuspendVariable();
			var.varFetch();
			return var.getValueInt() == 1;
		} catch (Exception e) {
			return false;
		}
	}

	public void resume() throws DebugException {
		try {
			System.err.println("resume()");
			SharedVariable var = getSuspendVariable();
			var.setValue(0);
			var.varStore();
//System.err.println("resume() OK");			
		} catch (Exception e) {
		}
		DebugUtils.fireResumeEvent(this,DebugEvent.CLIENT_REQUEST);
	}
	
	public void suspend() throws DebugException {
		try {
			System.err.println("suspend()");
			SharedVariable var = getSuspendVariable();
			var.setValue(1);
			var.varStore();
//System.err.println("suspend OK");		

//System.err.println("attempt stacktrace");
			engine.doRunnerStackTrace(DebugConstants.STACKTRACE_MSG_ID);
			System.err.println("REQUESTED RUNNER STACK TRACE FROM ENGINE");
//System.err.println("stacktrace OK");
		} catch (Exception e) {
		}
		DebugUtils.fireSuspendEvent(this,DebugEvent.CLIENT_REQUEST);
	}

	
//	suspend/resume 
//	breakpoints 
//	disconnect 

	public void breakpointAdded(IBreakpoint breakpoint) {
		// TODO Auto-generated method stub
	}
	public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
		// TODO Auto-generated method stub
	}
	public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
		// TODO Auto-generated method stub
	}

	public boolean canDisconnect() {
		return false;
	}
	public void disconnect() throws DebugException {
	}
	public boolean isDisconnected() {
		return false;
	}

	public boolean supportsStorageRetrieval() {
		return false;
	}

	public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
		return null;
	}
}