/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.handler;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.internal.operations.BindingDeletionDataModelProvider;
import org.eclipse.stp.core.internal.operations.IBindingDeletionDataModelProperties;
import org.eclipse.stp.core.internal.saf.impl.Messages;
import org.eclipse.stp.core.saf.exception.InvalidOperationException;
import org.eclipse.stp.core.saf.exception.SAFException;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

/**
 * This class is to be extended by all EntryPoint handler contributions.  
 */
public abstract class AbstractEntryPointHandler extends AbstractHandler implements IEntryPointHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IEntryPointHandler#canCreateEntryPointFor(java.lang.Object)
	 */
	public boolean canCreateEntryPointFor(Object service)
	{
		// No default support for creating entry points from model objects.
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IEntryPointHandler#canCreateEntryPointBinding()
	 */
	public boolean canCreateEntryPointBinding() {
		return true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IEntryPointHandler#canCreateManyEntryPointBindings()
	 */
	public boolean canCreateManyEntryPointBindings() {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IEntryPointHandler#isInterfaceKindSupported(org.eclipse.stp.core.saf.handler.IInterfaceHandler)
	 */
	public boolean isInterfaceKindSupported(IInterfaceHandler interfaceHandler) throws SAFException 
	{
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IEntryPointHandler#removeKind(org.eclipse.stp.core.sca.EntryPoint)
	 */
	final public IDataModelOperation removeKind(EntryPoint theEntryPoint)
			throws SAFException, InvalidOperationException {

		if (theEntryPoint == null) 
			throw new SAFException(Messages.stp_core_saf_entryPointMustNotBeNull); 

		IDataModel model = DataModelFactory.createDataModel(BindingDeletionDataModelProvider.class);
		model.setProperty(IBindingDeletionDataModelProperties.SCAOBJECT, theEntryPoint);
		model.setStringProperty(IBindingDeletionDataModelProperties.BINDING_TYPE, getKind());
				
		IStatus status = model.validate();
						
		if (status.isOK())
			return model.getDefaultOperation();	

		throw new SAFException(status.getMessage());

	}

}
