/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef;

import java.net.URL;
import java.util.ResourceBundle;

import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public final class PluginResources extends AbstractResources {
    private static final String BUNDLE_KEY = "org.eclipse.stp.ui.xef.PluginResources";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_KEY);
    
     
    private PluginResources() {
        // this is a utility class, no constructor allowed
    }

    public static ResourceBundle getResourceBundle() {
        return RESOURCE_BUNDLE;
    }
    
    public static Bundle getBundle() {
        return XefPlugin.getDefault().getBundle();
    }
    
    public static String getString(String key) {
        return getString(getResourceBundle(), key);
    }

    public static String[] getStringArray(String key) {
        return getStringArray(getResourceBundle(), key);
    }
    
    public static String getFromMsgFormat(String strKey, String strConcatValues, boolean fValuesIsKey) {
        return getFromMsgFormat(getResourceBundle(), strKey, strConcatValues, fValuesIsKey);
    }

    public static ImageDescriptor getImageDescriptor(String imageName) {
        return getImageDescriptor(getBundle(), imageName);
    }
    
    public static URL getImageUrl(String imageName) {
        return getImageUrl(getBundle(), imageName);
    }
    
}
