/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class BooleanControlAcccessor implements ControlAccessor {
    private final Composite container;
    
    BooleanControlAcccessor(Composite c) {
        container = c;
    }    
    
    public String getValue() {
        Button trueBtn = (Button) container.getData(Boolean.TRUE.toString());
        if (trueBtn.getSelection()) {
            return Boolean.TRUE.toString();
        } else { 
            return Boolean.FALSE.toString();
        }
    }

    public void setValue(String value) {
        Boolean b = Boolean.valueOf(value);        
        Boolean notB = Boolean.valueOf(!b.booleanValue());
        Button btn = (Button) container.getData(b.toString());
        Button otherBtn = (Button) container.getData(notB.toString());
        btn.setSelection(true);
        otherBtn.setSelection(false);
    }
}
