/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.schema;

import org.apache.xerces.xs.XSAttributeDeclaration;

public class SchemaAttribute implements AnnotatedElement {
    private final XSAttributeDeclaration ctx;
    private String defaultValue;
    private String exampleValue;
    private String fixed;
    private boolean required;
    private String category;
    private String documentation;
    private String docShort;
    private String displayName;
    private String filterId;
    private String fieldEditorId;
    private WidgetType widgetType;
    private String units;
    private String pattern;
    private String contextValueID;
    private String contextDataID;
    private String contextXPath;

    SchemaAttribute(XSAttributeDeclaration attrDeclaration) {
        ctx = attrDeclaration;
    }

    public String getName() {
        return ctx.getName();
    }

    public String getContextValueID() {
        return contextValueID;
    }

    public void setContextValueID(String id) {
        contextValueID = id;
    }
    
    public String getContextXPath() {
        return contextXPath;
    }

    public void setContextXPath(String xpath) {
        contextXPath = xpath;
    }
    
    public String getContextDataID() {
        return contextDataID;
    }
    
    public void setContextDataID(String id) {
        contextDataID = id;
    }
    
    public String getCategory() {
        return category;
    }

    public void setCategory(String c) {
        category = c;
    }

    public String getDisplayName() {
        if (displayName == null) {
            return getName();
        } else {
            return displayName;
        }
    }
    
    public void setDisplayName(String d) {
        displayName = d;
    }
    
    public SchemaValue getValue() {
        return new SchemaValue(ctx.getTypeDefinition());
    }

    public String getFixed() {
        return fixed;
    }
    
    void setFixed(String f) {
        fixed = f;
    }

    public String getDefault() {
        return defaultValue;
    }

    void setDefault(String def) {
        defaultValue = def;
    }    
    
    public String getExample() {
        return exampleValue;
    }
    
    void setExample(String ex) {
        exampleValue = ex;
    }
    
    public String getPattern() {
        return pattern;
    }
    
    public void setPattern(String p) {
        pattern = p;
    }
    
    public String [] getContextValues(IContextProvider ctx, String filter) {
        return ctx.getValues(contextValueID, filter);
    }
    
    public Object getContextData(IContextProvider ctx) {
        return ctx.getData(contextDataID);
    }
    
    public String getDocumentation() {
        return documentation;
    }
    
    void setDocumentation(String doc) {
        documentation = doc;
    }    
    
    public String getDocShort() {
        return docShort;
    }

    public void setDocShort(String ds) {
        docShort = ds;
    }

    public String getFilterId() {
        return filterId;
    }

    void setFilterId(String fid) {
        filterId = fid;
    }

    public String getFieldEditorId() {
        return fieldEditorId;
    }

    void setFieldEditorId(String fid) {
        fieldEditorId = fid;
    }

    public boolean getRequired() {
        return required;
    }
    
    void setRequired(boolean r) {
        required = r;
    }

    public String getUnits() {
        return units;
    }
    
    void setUnits(String u) {
        units = u;
    }
    
    public WidgetType getWidget() {
        return widgetType;
    }
    
    void setWidget(WidgetType w) {
        widgetType = w;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        
        if (!(obj instanceof SchemaAttribute)) {
            return false;
        }
        
        SchemaAttribute attr = (SchemaAttribute) obj;
        return ctx.equals(attr.ctx);
    }

    @Override
    public int hashCode() {
        return ctx.hashCode();
    }

    @Override
    public String toString() {
        return ctx.getNamespace() + ":" + ctx.getName();
    }
}
