/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.common.annotations.ext;

import java.lang.annotation.Annotation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * data model for annotation extensions
 */
public class AnnotationDef {
	
	private static final String EXT_ATT_SC_ANN_CLASS_ONLY = "classOnly";
	private static final String EXT_ATT_SC_ANN_INTERFACE_ONLY = "interfaceOnly";
	private static final String EXT_ATT_SC_ANN_NATURE = "nature";
    private static final String EXT_ATT_SC_ANN_INIT_CLASS = "initializerClass";
    private static final String EXT_ATT_SC_ANN_CLASS = "annotationClass";
    private static final String EXT_ATT_RESOLVER_ID = "resolverId";
    
	public String className;
	public IAnnotationInitializer initializerClass;
	public String name;
	public String natureId;
	public boolean interfaceOnly = false;
	public boolean classOnly = false;
	public String resolverId;
	Class <? extends Annotation> annotation = null;
	
	public void loadAnnotation(IConfigurationElement annElem) throws CoreException {
		className = annElem.getAttribute(EXT_ATT_SC_ANN_CLASS);
		initializerClass = (IAnnotationInitializer) 
		    annElem.createExecutableExtension(EXT_ATT_SC_ANN_INIT_CLASS);
		natureId = annElem.getAttribute(EXT_ATT_SC_ANN_NATURE);
		//process class only
        classOnly = new Boolean(annElem.getAttribute(EXT_ATT_SC_ANN_CLASS_ONLY));
        //process interface only
        interfaceOnly = new Boolean(annElem.getAttribute(EXT_ATT_SC_ANN_INTERFACE_ONLY));
        resolverId = annElem.getAttribute(EXT_ATT_RESOLVER_ID);
	}

}
