/*******************************************************************************
 * Copyright (c) 2003-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

/**
 * Base interface for servers.  This interface is used for identifying server
 * types for use in generating configuration and modifying resources for a
 * specific server type.
 * 
 * @author rcernich
 *
 * Created on Nov 13, 2003
 */
public interface IServerType {
	
	IServerDefinition getServerDefinition();
	
	IVersion getVersion();

	/**
	 * @param o
	 * @return getServerDefinition().equals(getServerDefinition()) && getVersion().equals(o.getVersion())
	 */
	boolean equals(Object o);
	
	/**
	 * @return an appropriate hash code (e.g. getServerDefinition().hashCode())
	 */
	int hashCode();

}
