/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

/**
 * 
 * Module delegate for service component
 * 
 * @author jma
 */
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JarUtils;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class ServiceModuleDelegate extends ProjectModule implements IWebModule{
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(ServiceModuleDelegate.class);
	
	IPath ROOT = new Path("/"); //$NON-NLS-1$ 
	
	FilePackageOutputDescriptor fileDesc;
	
	IModule module;

	/**
	 * create service module delegate from project and packageDescriptor
	 * @param project, the project which contains the module
	 * @param desc, the package descriptor
	 * @see IPackageOutputDescriptor
	 */
	public ServiceModuleDelegate(IProject project, IPackageOutputDescriptor desc) {
		super(project);
		fileDesc = (FilePackageOutputDescriptor)desc;		
	}
	
	@Override
	public IModule[] getChildModules() {
		//we don't have any child module yet.
		//for sca module, the service may consistent with small components
		return null;
	}

	@Override
	public IModuleResource[] members() throws CoreException {
		String outputDirectory = "";
		File[] files;
		if (fileDesc != null) {
			File file = fileDesc.getFile();
			String moduleName = file.getName();
			File folder = file.getParentFile();
			outputDirectory = folder.getAbsolutePath() + File.separator
					+ moduleName + "_tmp";

			if (file.getName().endsWith(".war")) {

				try {
					JarUtils.unJarFile(file.getAbsolutePath(), outputDirectory);
				} catch (Exception e) {

					IStatus status = new Status(Status.ERROR,
							DeployCorePlugin.PLUGIN_ID, Status.OK,
							"Invalid package file: " + file.getAbsolutePath(),
							(Throwable) e);
					throw new CoreException(status);
				}
			}
			files = new File(outputDirectory).listFiles();
		}
		else{
			outputDirectory = getProject().getFolder("Webcontext").getLocation().toOSString();
			files = new File(outputDirectory).listFiles();
		}
		
       File warfolder = new File(outputDirectory);
       List<IModuleResource> reses = new ArrayList<IModuleResource>();
       for(File member: files){
    	   if(member.isDirectory()){
    		   ModuleFolder mFolder = getModuleFolderMembers(member, Path.EMPTY);
    		   reses.add(mFolder);
    	   }
    	   else{
    		   ModuleFile mFile = new ModuleFile(member, member.getName(), Path.EMPTY);
    		   reses.add(mFile);
    	   }
       }
        
		return reses.toArray(new IModuleResource[reses.size()]);
	}
 
	private ModuleFolder getModuleFolderMembers(File folder, IPath path){
		
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IContainer container = root.getContainerForLocation(new Path(folder.getAbsolutePath()));
		//ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(location)
		ModuleFolder mFolder = new ModuleFolder(container,  folder.getName(), path);
		IModuleResource[] res = new IModuleResource[folder.listFiles().length];
		int i = 0; 
		for(File file: folder.listFiles()){
			if(file.isDirectory()){
				ModuleFolder mf = getModuleFolderMembers(file, path.append(file.getParentFile().getName()));
				res[i] = mf;
			}else
			{
				ModuleFile mfile = new ModuleFile(file,
						file.getName(),
		        		path.append(file.getParentFile().getName()));
				res[i] = mfile;
			}
			
			i++;
		}
		mFolder.setMembers(res);
		return mFolder;
	}
	@Override
	public IStatus validate() {
		//just return ok for now. will revisit to check the package later
		return Status.OK_STATUS;
	}

 	public String getContextRoot() {
 		if(fileDesc != null){
 		String context = fileDesc.getFile().getName();
 		if (context.lastIndexOf(".") > 0) {
 			context = context.substring(0, context.lastIndexOf("."));
 		}
 		LOG.debug("getContextRoot return:" + context);
 		return context;
 		}
 		else{
 			return getProject().getName(); 			
 		}
	}

 	public void setModule(IModule mod) {
 		module = mod;
 	}
 	
	public IModule[] getModules() {
		return new IModule[]{module};
	}

	public String getURI(IModule module) {
		LOG.debug("get url called for module:" + module);
		if(fileDesc != null){
			return fileDesc.getLogicalName();
		}else
		{
			return getProject().getName() + ".war";
		}
	}

	public IContainer[] getJavaOutputFolders() {
		return null;
	}

	public IContainer[] getResourceFolders() {
		return null;
	}

	public boolean isBinary() {
		return true;
	}

}
