/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.EmptyContainerFilter;
import org.eclipse.stp.soas.internal.deploy.ui.PackagesFilter;
import org.eclipse.stp.soas.internal.deploy.ui.ProjectsFilter;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.DialogPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/**
 * @author rcernich
 * 
 * Created on Jan 28, 2004
 */
public class PackageSelectionDialogPage extends DialogPage {

	public static final String TITLE;
	public static final String ICON_PATH;
	public static final ImageDescriptor ICON_DESC;

	public static final String LABEL_SELECT_PACKAGES;
	public static final int MIN_TREE_HEIGHT;

	private IProject mSourceProject;
	private List mExistingPackages;
	private CheckboxTreeViewer mPackageViewer;
	private IResource[] mSelection = new IResource[0];

	public PackageSelectionDialogPage() {
		this(TITLE, ICON_DESC);
	}

	/**
	 * @param title
	 * @param image
	 */
	public PackageSelectionDialogPage(String title, ImageDescriptor image) {
		super(title, image);
		setNeedsApplyButton(false);
	}

	public void init(IProject sourceProject, Root root) {
		mSourceProject = sourceProject;
		List packages = root.getPackage();
		mExistingPackages = new Vector(packages.size());
		for (Iterator it = packages.iterator(); it.hasNext();) {
			DeployPackage dp = (DeployPackage) it.next();
			mExistingPackages.add(dp.getPackageFile());
		}
		Collections.sort(mExistingPackages);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		Composite content = new Composite(parent, SWT.NULL);
		content.setLayout(new GridLayout(1, false));
		content.setLayoutData(new GridData(GridData.FILL_BOTH));

		Label label = new Label(content, SWT.NULL);
		label.setText(LABEL_SELECT_PACKAGES);
		GridData data = new GridData();
		label.setLayoutData(data);

		mPackageViewer = new CheckboxTreeViewer(content, SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.BORDER);
		mPackageViewer.setAutoExpandLevel(3);
		mPackageViewer.setContentProvider(new WorkbenchContentProvider());
		mPackageViewer.setLabelProvider(new WorkbenchLabelProvider());
		mPackageViewer.addFilter(new PackagesFilter());
		//mPackageViewer.addFilter(new ProjectsFilter(mSourceProject));
		mPackageViewer.addFilter(new EmptyContainerFilter());
		mPackageViewer.addFilter(new ViewerFilter() {

			public boolean select(Viewer viewer, Object parentElement,
					Object element) {
				boolean retVal;
				if (element instanceof IFile) {
					retVal = Collections.binarySearch(mExistingPackages,
							((IFile) element).getFullPath()
									.toString()) < 0;
				}
				else {
					retVal = true;
				}
				return retVal;
			}
		});
		data = new GridData(GridData.FILL_BOTH);
		data.heightHint = mPackageViewer.getTree().getItemHeight()
				* MIN_TREE_HEIGHT;
		mPackageViewer.getTree().setLayoutData(data);
		mPackageViewer.addCheckStateListener(new ICheckStateListener() {

			public void checkStateChanged(CheckStateChangedEvent event) {
				handleCheckStateChanged();
			}
		});

		initControls();

		setControl(content);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.ui.dialogs.DialogPage#performOk()
	 */
	public boolean performOk() {
		Object[] selection = mPackageViewer.getCheckedElements();
		Vector files = new Vector(selection.length);
		for (int index = 0, count = selection.length; index < count; ++index) {
			IResource res = (IResource) selection[index];
			if (res.getType() == IResource.FILE) {
				files.add(res);
			}
		}
		mSelection = (IResource[]) files.toArray(new IResource[files.size()]);
		return true;
	}

	public IResource[] getSelection() {
		return mSelection;
	}

	private void initControls() {
		mPackageViewer.setInput(DeployCorePlugin.getWorkspace().getRoot());

		updateControls();

		validate();
	}

	private void updateControls() {
		// Nothing to do here
	}

	private void validate() {
		if (mPackageViewer.getCheckedElements().length > 0) {
			setErrorMessage(null);
			setIsValid(true);
		}
		else {
			setErrorMessage(DeployCorePlugin.getDefault().getResourceString("PackageSelectionDialogPage.error.noPackagesSelected")); //$NON-NLS-1$
			setIsValid(false);
		}
	}

	private void handleCheckStateChanged() {
		setIsModified(true);

		updateControls();

		validate();
	}

	static {
		TITLE = DeployCorePlugin.getDefault().getResourceString("PackageSelectionDialogPage.title.selectPackages"); //$NON-NLS-1$
		ICON_PATH = "icons/blank_wizard_graphic.gif"; //$NON-NLS-1$
		URL url = null;
		try {
			url = DeployCorePlugin.getDefault().getBundle().getEntry(ICON_PATH);
		}
		catch (RuntimeException e) {
			e.printStackTrace();
		}
		if (url == null) {
			ICON_DESC = ImageDescriptor.getMissingImageDescriptor();
		}
		else {
			ICON_DESC = ImageDescriptor.createFromURL(url);
		}
		LABEL_SELECT_PACKAGES = DeployCorePlugin.getDefault().getResourceString("PackageSelectionDialogPage.LABEL.selectPackages"); //$NON-NLS-1$
		MIN_TREE_HEIGHT = 15;
	}

}
