/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFSectionPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

/**
 * @author rcernich
 * 
 * Created on Jan 17, 2005
 */
public abstract class DeployEditorSectionPart extends EMFSectionPart {

	private ImageHyperlink mHelpImage;

	/**
	 * @param parent
	 * @param toolkit
	 * @param style
	 */
	public DeployEditorSectionPart(Composite parent, FormToolkit toolkit,
									int style) {
		super(parent, toolkit, style);

		// Add help icon
		Composite textClient = new Composite(getSection(), SWT.NONE);
		textClient.setSize(32, 16);
		toolkit.adapt(textClient, true, true);
		RowLayout rowLayout = new RowLayout();
		rowLayout.wrap = false;
		rowLayout.pack = false;
		rowLayout.justify = true;
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.marginLeft = 0;
		rowLayout.marginTop = 0;
		rowLayout.marginRight = 0;
		rowLayout.marginBottom = 0;
		rowLayout.spacing = 0;
		textClient.setLayout(rowLayout);
		getSection().setTextClient(textClient);

		mHelpImage = new ImageHyperlink(textClient, SWT.NONE);
		toolkit.adapt(mHelpImage, true, true);
		mHelpImage.setImage(DeployCorePlugin.getDefault().getImage(
				"help.gif")); //$NON-NLS-1$
		mHelpImage.setToolTipText(DeployCorePlugin.getDefault()
				.getResourceString("TOOLTIP.Help")); //$NON-NLS-1$
		mHelpImage.addHyperlinkListener(new HyperlinkAdapter() {

			public void linkActivated(HyperlinkEvent event) {
				helpActivated(event);
			}
		});
	}

	protected void setHelpToolTipText(String toolTip) {
		mHelpImage.setToolTipText(toolTip);
	}

	protected void helpActivated(HyperlinkEvent event) {
		PlatformUI.getWorkbench().getHelpSystem().displayHelp();
	}

	public void dispose() {
		mHelpImage.getImage().dispose();
		super.dispose();
	}
}