/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.misc;


/**
 * 
 * @author amiguel
 *
 * A class to translate a string to and from a hexadecimal representation
 */
public class HexData {

    private static char[] hexChars = { '0', '1', '2', '3', '4', '5', '6', '7', '8','9', 'A', 'B', 'C', 'D', 'E', 'F' };

    private static void byteToHex(byte b, StringBuffer buf) {
    	int high = ((b & 0xf0) >> 4);
        int low = (b & 0x0f);
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }//end method

    private static byte hexToByte(byte b) {
    	if (b >= 47 && b <= 57) {
    		return (byte)(b-48);
    	}//end if
    	return (byte)(b-55); //A starts on 65 ( 65-55 = 10 = A)
    }//end method

	public static String stringToHexString(String s) {
		return byteArrayToHexString(s.getBytes());	
	}
	
	public static String hexStringToString(String s) {
		return new String(hexStringToByteArray(s));	
	}

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; i++) {
            byteToHex(bytes[i],sb);
        }//end for
        return sb.toString();
    }//end method

    public static byte[] hexStringToByteArray(String s) {
        byte[] string_bytes = s.getBytes();
        byte[] output_bytes = new byte[string_bytes.length/2];
        for (int i = 0; i < string_bytes.length; i+=2) {
            int hi = (hexToByte(string_bytes[i]) << 4);
            int lo = hexToByte(string_bytes[i+1]);
            byte b = (byte) ( hi | lo );
            output_bytes[i/2] = b;
        }//end for
        return output_bytes;
    }//end method

}
