/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.stp.b2j.ui.UiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PrefPage extends PreferencePage implements IWorkbenchPreferencePage {

Composite main_panel;

//TransportsTable transports_table;

Label bindings_label;
BindingTypeTable bindings_table;


	protected Control createContents(Composite parent) {
		
		main_panel = new Composite(parent,SWT.NONE);
		main_panel.setLayout(new GridLayout(1,false));

//		transports_table = new TransportsTable(main_panel,SWT.BORDER|SWT.V_SCROLL);
//		transports_table.setLayoutData(new GridData(GridData.FILL,GridData.FILL,true,true,1,1));
		
		bindings_label = new Label(main_panel,SWT.NONE);
		bindings_label.setText(UiPlugin.getString(""));
		
		bindings_table = new BindingTypeTable(main_panel,SWT.BORDER);
		bindings_table.setLayoutData(new GridData(GridData.FILL,GridData.FILL,true,true,1,1));
		
		//
		// Initial state
		//
		performInit();
		
		return main_panel;
	}

	public void init(IWorkbench workbench) {
		setPreferenceStore(UiPlugin.getDefault().getPreferenceStore());
	}
	
	protected IPreferenceStore doGetPreferenceStore() {
		return UiPlugin.getDefault().getPreferenceStore();
	}
	
	private void performInit() {
		//
		// Load from preference store
		//
		IPreferenceStore store = getPreferenceStore();
	}

	protected void performDefaults() {
		//
		// Load from preference store (defaults)
		//
		IPreferenceStore store = getPreferenceStore();
	}			
	
	public boolean performOk() {
		//
		// Store to preference store
		//
		IPreferenceStore store = getPreferenceStore();
		return super.performOk();
	}

	
	
}