/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.sca.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.FacetUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;

public class ScaFacetInstallDelegate extends J2EEFacetInstallDelegate
		implements IDelegate {

	public static final String FACET_PROJECT_NATURE 
    = FacetCorePlugin.PLUGIN_ID + ".nature";
	
	public static final String MODULE_TYPE = "stp.sca.component";
    public static final String MODULE_VERSION = "1.0";
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScaFacetInstallDelegate.class);
	
	public void execute(IProject project, IProjectFacetVersion fv,
			Object config, IProgressMonitor monitor) throws CoreException {
		if (monitor != null) {
			monitor.beginTask("Installing SCA facet", 1);
		}

		try {
			IDataModel model = (IDataModel) config;

			final IJavaProject jproj = JavaCore.create(project);

			// Add WTP natures.
			WtpUtils.addNatures(project);

			// Setup the flexible project structure.
			final IVirtualComponent c = ComponentCore.createComponent(project);
			c.create(0, null);
			c.setMetaProperty("java-output-path", "/classes/");

			final IVirtualFolder jaxwsRoot = c.getRootFolder();

			// Create directory structure
			String srcFolder = null;
			jaxwsRoot.createLink(new Path("/src"), 0, null);
			jaxwsRoot.createLink(new Path("/wsdl"), 0, null);

			if (monitor != null) {
				monitor.worked(1);
			}
		}

		finally {
			if (monitor != null) {
				monitor.done();
			}
		}

	}
	
	
	public static void addScaFacet(IProject project) {
		try {
			WtpUtils.addNatures(project);
			FacetUtils.addFacetNature(project);
			//add java facet is doens't exists
			FacetUtils.addFacet(project, 
					FacetUtils.JAVA_FACET, 
					FacetUtils.JAVA_FACET_VERSION);
			FacetUtils.addFacet(project, 
					FacetUtils.JAVAWEB_FACET, 
					FacetUtils.JAVAWEB_FACET_VERSION);
			//add jax-ws facet
			FacetUtils.addFacet(project, MODULE_TYPE, MODULE_VERSION);
			
		} catch (Exception e) {
			e.printStackTrace();
			LOG.error("error when setup jaxws facet.", e);
		}
	}	

}
