/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IAdditionalPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IStartingPointPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.workspace.ScJavaFirstNature;
import org.eclipse.ui.PlatformUI;

public class WebServiceProjectWizard extends ProjectWizardBase {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(WebServiceProjectWizard.class);
	
	public static final String STARTING_POINT_PAGE_NAME = "startingPointPage";
	
    protected StartingPointWizardPage startingPointPage = null;
    
    //AdditionalWizardPage[] additionalPages = null;
	
	public WebServiceProjectWizard() {
        super();
        projectMode = ScJaxWsPropertyConstants.PROJECT_MODE_JAVAFIRST;
        
        //TODO hqf only for test (to be deleted)
//        RuntimeProviderManager rtMgr = RuntimeProviderManager.getInstance();
//        rtMgr.setUseDefaultRuntime(false);
//        rtMgr.setDefaultRuntime("org.eclipse.stp.soas.deploy.runtime.cxf.20", "Apache CXF 2.0");
    }
    
    
    public void addPages() {
	    super.addPages();
	    startingPointPage = new StartingPointWizardPage(STARTING_POINT_PAGE_NAME);
	    RuntimeProviderManager rtMgr = RuntimeProviderManager.getInstance();
	    if(rtMgr.getUseDefaultRuntime()){
	    	//set page contents
	    	IStartingPointPageContents pageContents = rtMgr.getStartingPointPage(rtMgr.getDefaultRuntimeType()); 
	    	startingPointPage.setPageContents(pageContents);
	    	
	    	//setup next page if need
	    	IAdditionalPageContents addPageContents = rtMgr.getAdditionalPage(rtMgr.getDefaultRuntimeType());
	    	if(addPageContents != null){
	    		AdditionalWizardPage newWizardPage = new AdditionalWizardPage(addPageContents.getPageName(), addPageContents);
	    		newWizardPage.setWizard(this);
	    		startingPointPage.setNextPage(newWizardPage);
	    	}
	    }
        addPage(startingPointPage);
	}
    
    public boolean performFinish() {
        try {
            super.performFinish();
           
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
	    	IRunnableWithProgress rwp = new IRunnableWithProgress() {
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                	invokeAdditionalPages();
                }
	    	};
	        pmd.run(false, false, rwp);    
	        
	        ScJavaFirstNature.addToProject(project);
        } catch (Exception e) {
        	LOG.error(e.getMessage(), e);
        } 
        return true;
    }
    
    private void invokeAdditionalPages(){
    	IWizardPage additionalPage = startingPointPage;
    	while(additionalPage != null){
    		if(additionalPage instanceof WizardPageBase){
    			if(additionalPage.getControl() == null){
    				additionalPage.createControl(this.getShell());
    			}
    			((WizardPageBase)additionalPage).performFinish(project);
    		}
    		additionalPage = additionalPage.getNextPage();
    	}
    }
    
}
