/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.core.resources.IProject;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.workspace.ScJavaFirstNature;

public class JavaFirstEnableWizard extends EnableWizardBase {
	
	
	public static final String STARTING_POINT_PAGE_NAME = "startingPointPage";
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(JavaFirstEnableWizard.class);
	
	StartingPointPage startingPointPage;

	public JavaFirstEnableWizard(IProject project){
		super(project);
	}
	
	public void addPages(){
		super.addPages();
		startingPointPage = new StartingPointPage(STARTING_POINT_PAGE_NAME);
		startingPointPage.setPageContents(new StartingPointPageContents(project));
		addPage(startingPointPage);
		
		RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
		if(!runtimeMgr.getUseDefaultRuntime()){
			startingPointPage.setRuntimeInfo(runtimeMgr.getDefaultRuntimeType(), runtimeMgr.getDefaultRuntimeID());
		}
	}
	
	public boolean performFinish(){
		try{
			super.performFinish();

			ScJavaFirstNature.addToProject(project);
			
			startingPointPage.performFinish(project);
			
		}catch(Exception ex){
			LOG.error("error whilc enabling jaxws", ex);
			return false;
		}
		return true;
	}
}
