/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.stp.core.infrastructure.emf.IResourceAssistant;

/**
 * Overrides how URIs that contain references to ComponentType implementations
 * are loaded.
 * 
 * @since 1.0
 * 
 */
public class ComponentTypeResourceHandler implements IResourceAssistant {

   protected static final String     COMPONENT_TYPE   = "comptype";                        //$NON-NLS-1$

   private static IResourceAssistant instance         = new ComponentTypeResourceHandler();

   private ResourceSet[]             NO_RESOURCE_SETS = new ResourceSet[0];

   protected static IResourceAssistant getInstance() {
      return instance;
   }

   protected ComponentTypeResourceHandler() {
   }

   public Resource getResource(ResourceSet originatingResourceSet, URI uri) {
      return null;
   }

   public EObject getEObjectFailed(ResourceSet originatingResourceSet, URI uri,
         boolean loadOnDemand) {
      return null;
   }

   public Resource createResource(ResourceSet originatingResourceSet, URI uri) {
      if (!COMPONENT_TYPE.equals(uri.scheme()))
         return null;

      Resource componentTypeResource = null;
      if (ComponentTypeIntrospectorRegistry.getInstance().hasIntrospector(uri)) {
         componentTypeResource = new AbstractComponentTypeResource(uri);
         originatingResourceSet.getResources().add(componentTypeResource);
      }
      return componentTypeResource;
   }

   public ResourceSet[] getManagedResourceSets() {
      return NO_RESOURCE_SETS;
   }

}
