/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;

import org.eclipse.stp.core.internal.introspection.query.IModelQuery;

/**
 * A simple stack for dealing with AnnouncementTypeEnums
 * 
 * @since 1.0
 * 
 */
public class ModelDeltaStack {

   private final List stack = new ArrayList();

   public void push(IModelQuery aFeature) {
      stack.add(aFeature);
   }

   public IModelQuery peek() {
      if (stack.size() == 0)
         throw new EmptyStackException();
      return (IModelQuery) stack.get(stack.size() - 1);
   }

   public IModelQuery pop() {
      if (stack.size() == 0)
         throw new EmptyStackException();
      return (IModelQuery) stack.remove(stack.size() - 1);
   }

   public boolean isEmpty() {
      return stack.isEmpty();
   }
}
