/**
 * <copyright> </copyright>
 * 
 * $Id: PropertyImpl.java,v 1.3 2007/07/18 03:33:11 qhuang Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import javax.xml.namespace.QName;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Property</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.PropertyImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.PropertyImpl#getDefault <em>Default</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.PropertyImpl#isMany <em>Many</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.PropertyImpl#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.PropertyImpl#isRequired <em>Required</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.PropertyImpl#getType <em>Type</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.PropertyImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class PropertyImpl extends SCAInternalObjectImpl implements Property {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String     copyright         = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap           any               = null;

   /**
    * The default value of the '{@link #getDefault() <em>Default</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getDefault()
    * @generated
    * @ordered
    */
   protected static final String  DEFAULT_EDEFAULT  = null;

   /**
    * The cached value of the '{@link #getDefault() <em>Default</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getDefault()
    * @generated
    * @ordered
    */
   protected String               default_          = DEFAULT_EDEFAULT;

   /**
    * The default value of the '{@link #isMany() <em>Many</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #isMany()
    * @generated
    * @ordered
    */
   protected static final boolean MANY_EDEFAULT     = false;

   /**
    * The cached value of the '{@link #isMany() <em>Many</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #isMany()
    * @generated
    * @ordered
    */
   protected boolean              many              = MANY_EDEFAULT;

   /**
    * This is true if the Many attribute has been set. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   protected boolean              manyESet          = false;

   /**
    * The default value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected static final String  NAME_EDEFAULT     = null;

   /**
    * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected String               name              = NAME_EDEFAULT;

   /**
    * The default value of the '{@link #isRequired() <em>Required</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #isRequired()
    * @generated
    * @ordered
    */
   protected static final boolean REQUIRED_EDEFAULT = false;

   /**
    * The cached value of the '{@link #isRequired() <em>Required</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #isRequired()
    * @generated
    * @ordered
    */
   protected boolean              required          = REQUIRED_EDEFAULT;

   /**
    * This is true if the Required attribute has been set. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   protected boolean              requiredESet      = false;

   /**
    * The default value of the '{@link #getType() <em>Type</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getType()
    * @generated
    * @ordered
    */
   protected static final Object  TYPE_EDEFAULT     = null;

   /**
    * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getType()
    * @generated
    * @ordered
    */
   protected Object               type              = TYPE_EDEFAULT;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap           anyAttribute      = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected PropertyImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getProperty();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.PROPERTY__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getDefault() {
      return default_;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setDefault(String newDefault) {
      String oldDefault = default_;
      default_ = newDefault;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.PROPERTY__DEFAULT, oldDefault, default_));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean isMany() {
      return many;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setMany(boolean newMany) {
      boolean oldMany = many;
      many = newMany;
      boolean oldManyESet = manyESet;
      manyESet = true;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.PROPERTY__MANY, oldMany, many, !oldManyESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void unsetMany() {
      boolean oldMany = many;
      boolean oldManyESet = manyESet;
      many = MANY_EDEFAULT;
      manyESet = false;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.UNSET,
               SCAPackage.PROPERTY__MANY, oldMany, MANY_EDEFAULT, oldManyESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean isSetMany() {
      return manyESet;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getName() {
      return name;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setName(String newName) {
      String oldName = name;
      name = newName;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.PROPERTY__NAME, oldName, name));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean isRequired() {
      return required;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setRequired(boolean newRequired) {
      boolean oldRequired = required;
      required = newRequired;
      boolean oldRequiredESet = requiredESet;
      requiredESet = true;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.PROPERTY__REQUIRED, oldRequired, required,
               !oldRequiredESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void unsetRequired() {
      boolean oldRequired = required;
      boolean oldRequiredESet = requiredESet;
      required = REQUIRED_EDEFAULT;
      requiredESet = false;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.UNSET,
               SCAPackage.PROPERTY__REQUIRED, oldRequired, REQUIRED_EDEFAULT,
               oldRequiredESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean isSetRequired() {
      return requiredESet;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object getType() {
      return type;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setType(Object newType) {
      Object oldType = type;
      QName newTypeQName = null;
      if(newType instanceof QName){
         newTypeQName = (QName)newType;
      }else{
         newTypeQName = QName.valueOf(newType.toString());
      }
      type = newTypeQName;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.PROPERTY__TYPE, oldType, type));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.PROPERTY__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.PROPERTY__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.PROPERTY__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.PROPERTY__ANY:
            return getAny();
         case SCAPackage.PROPERTY__DEFAULT:
            return getDefault();
         case SCAPackage.PROPERTY__MANY:
            return isMany() ? Boolean.TRUE : Boolean.FALSE;
         case SCAPackage.PROPERTY__NAME:
            return getName();
         case SCAPackage.PROPERTY__REQUIRED:
            return isRequired() ? Boolean.TRUE : Boolean.FALSE;
         case SCAPackage.PROPERTY__TYPE:
            return getType();
         case SCAPackage.PROPERTY__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.PROPERTY__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.PROPERTY__DEFAULT:
            setDefault((String) newValue);
            return;
         case SCAPackage.PROPERTY__MANY:
            setMany(((Boolean) newValue).booleanValue());
            return;
         case SCAPackage.PROPERTY__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.PROPERTY__REQUIRED:
            setRequired(((Boolean) newValue).booleanValue());
            return;
         case SCAPackage.PROPERTY__TYPE:
            setType((Object) newValue);
            return;
         case SCAPackage.PROPERTY__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.PROPERTY__ANY:
            getAny().clear();
            return;
         case SCAPackage.PROPERTY__DEFAULT:
            setDefault(DEFAULT_EDEFAULT);
            return;
         case SCAPackage.PROPERTY__MANY:
            unsetMany();
            return;
         case SCAPackage.PROPERTY__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.PROPERTY__REQUIRED:
            unsetRequired();
            return;
         case SCAPackage.PROPERTY__TYPE:
            setType(TYPE_EDEFAULT);
            return;
         case SCAPackage.PROPERTY__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.PROPERTY__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.PROPERTY__DEFAULT:
            return DEFAULT_EDEFAULT == null ? default_ != null
                  : !DEFAULT_EDEFAULT.equals(default_);
         case SCAPackage.PROPERTY__MANY:
            return isSetMany();
         case SCAPackage.PROPERTY__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.PROPERTY__REQUIRED:
            return isSetRequired();
         case SCAPackage.PROPERTY__TYPE:
            return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT
                  .equals(type);
         case SCAPackage.PROPERTY__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", default: "); //$NON-NLS-1$
      result.append(default_);
      result.append(", many: "); //$NON-NLS-1$
      if (manyESet)
         result.append(many);
      else
         result.append("<unset>"); //$NON-NLS-1$
      result.append(", name: "); //$NON-NLS-1$
      result.append(name);
      result.append(", required: "); //$NON-NLS-1$
      if (requiredESet)
         result.append(required);
      else
         result.append("<unset>"); //$NON-NLS-1$
      result.append(", type: "); //$NON-NLS-1$
      result.append(type);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

} // PropertyImpl
