/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.net.URL;
import java.util.HashMap;

/**
 * 
 * @author amiguel
 *
 * An HTTP implementation test case
 */
public class HTTPTest implements HTTPServerListener {
	
	static URL[] urls;
	static URL[] invalid_urls;

	public static void main(String[] args) {
		try {
			
			urls = new URL[]{
					new URL("http://localhost:2001/"),
					new URL("http://localhost:2001/ASpaceOddessy"),
					new URL("http://localhost:2001/ASpaceOddessy/IsThatSpelledRight?"),
					new URL("http://localhost:2064/AnotherSpaceOddessy"),
			};
			invalid_urls = new URL[]{
					new URL("http://localhost:2002/"),	//bad port
					new URL("http://localhost:2001/SomeOtherBook"),	//bad resource
					new URL("http://localhost:2001/ASpaceOddessy/WrongAuthor"),	//bad sub resource
			};
			
			new HTTPTest();

			
			Thread.sleep(2000);

			while (true) Thread.sleep(2000);
			/*
			for (int i = 0; i < urls.length; i++) {
				System.out.println("**********************");
				System.out.println("Requesting "+urls[i]+"...");
				try {
					InputStream in = urls[i].openStream();
					String response = StreamUtils.readAllAsString(in);
					System.out.println("**********************");
					System.out.println(response);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			
			for (int i = 0; i < invalid_urls.length; i++) {
				System.out.println("**********************");
				System.out.println("Requesting "+invalid_urls[i]+"...");
				try {
					InputStream in = invalid_urls[i].openStream();
					String response = StreamUtils.readAllAsString(in);
					System.out.println("**********************");
					System.out.println(response);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			*/
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public HTTPTest() throws Exception {
		for (int i = 0; i < urls.length; i++) {
			HTTPServer.addHttpListener(urls[i],this);
		}
	}
	
	public HTTPResponse doRequest(int port, String resource, String payload, HashMap lc_headers) throws HTTPException {
		return new HTTPResponse("Hello World ("+port+") ("+resource+") ("+payload+") ("+lc_headers.size()+" headers)");
	}
	
}